/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.projectile;

import mod.schnappdragon.habitat.core.misc.HabitatDamageSources;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class KabloomFruitEntity
extends ProjectileItemEntity {
    public KabloomFruitEntity(EntityType<? extends KabloomFruitEntity> entity, World world) {
        super(entity, world);
    }

    public KabloomFruitEntity(World worldIn, LivingEntity throwerIn) {
        super((EntityType)HabitatEntityTypes.KABLOOM_FRUIT.get(), throwerIn, worldIn);
    }

    public KabloomFruitEntity(World worldIn, double x, double y, double z) {
        super((EntityType)HabitatEntityTypes.KABLOOM_FRUIT.get(), x, y, z, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)HabitatSoundEvents.ENTITY_KABLOOM_FRUIT_EXPLODE.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f, true);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184543_l()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.8, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08);
            }
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        this.createExplosion();
    }

    protected Item func_213885_i() {
        return (Item)HabitatItems.KABLOOM_FRUIT.get();
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)HabitatItems.KABLOOM_FRUIT.get());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Vector3d func_213308_a(Vector3d pos) {
        this.createExplosion();
        return Vector3d.field_186680_a;
    }

    private void createExplosion() {
        Vector3d vector3d = this.func_213303_ch();
        if (((GameRules.BooleanValue)this.field_70170_p.func_82736_K().func_223585_a(GameRules.field_223604_g)).func_223572_a()) {
            ItemEntity item = new ItemEntity(this.field_70170_p, vector3d.func_82615_a() + this.field_70146_Z.nextGaussian() / 2.0, vector3d.func_82617_b() + this.field_70146_Z.nextDouble() / 2.0, vector3d.func_82616_c() + this.field_70146_Z.nextGaussian() / 2.0, new ItemStack((IItemProvider)HabitatItems.KABLOOM_PULP.get()));
            item.func_174869_p();
            this.field_70170_p.func_217376_c((Entity)item);
        }
        for (Entity entity : this.field_70170_p.func_72839_b(null, this.func_174813_aQ().func_186662_g(0.75))) {
            double dz;
            double dy;
            double dx;
            double dres;
            boolean flag = false;
            for (int i = 0; i < 2; ++i) {
                BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, new Vector3d(entity.func_226277_ct_(), entity.func_226283_e_(0.5 * (double)i), entity.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            float dmg = 0.0f;
            if (!entity.func_180427_aV() && (dres = (double)MathHelper.func_76133_a((double)((dx = entity.func_226277_ct_() - this.func_226277_ct_()) * dx + (dy = entity.func_226280_cw_() - this.func_226278_cu_()) * dy + (dz = entity.func_226281_cx_() - this.func_226281_cx_()) * dz))) != 0.0) {
                PlayerEntity playerentity;
                dx /= dres;
                dy /= dres;
                dz /= dres;
                double df = this.func_70032_d(entity) > 1.0f ? 0.25 : 0.5;
                dmg = 4.0f + 4.0f * (float)df;
                double dred = df;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    dred = ProtectionEnchantment.func_92092_a((LivingEntity)livingEntity, (double)df) * (1.0 - livingEntity.func_233637_b_(Attributes.field_233820_c_));
                }
                boolean knockback = true;
                if (entity instanceof PlayerEntity && ((playerentity = (PlayerEntity)entity).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b)) {
                    knockback = false;
                }
                if (knockback) {
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c(dx * dred, dy * dred, dz * dred));
                }
            }
            if (entity instanceof LivingEntity) {
                entity.func_70097_a(HabitatDamageSources.causeKabloomDamage(this, this.func_234616_v_()).func_94540_d(), dmg);
            } else if (entity.func_70075_an()) {
                entity.func_70097_a(HabitatDamageSources.causeKabloomDamage(this, this.func_234616_v_()), dmg);
            }
            if (!this.func_70027_ad() || entity.func_230279_az_()) continue;
            entity.func_70015_d(1);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }
}

