/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import mod.schnappdragon.habitat.core.registry.HabitatLootConditionTypes;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fml.ModList;

public class IsModLoaded
implements ILootCondition {
    private final String modid;

    public IsModLoaded(String modid) {
        this.modid = modid;
    }

    public LootConditionType func_230419_b_() {
        return HabitatLootConditionTypes.IS_MOD_LOADED;
    }

    public boolean test(LootContext lootContext) {
        return ModList.get().isLoaded(this.modid);
    }

    public static ILootCondition.IBuilder builder(String modid) {
        return () -> new IsModLoaded(modid);
    }

    public static class Serializer
    implements ILootSerializer<IsModLoaded> {
        public void serialize(JsonObject object, IsModLoaded instance, JsonSerializationContext context) {
            object.addProperty("modid", instance.modid);
        }

        public IsModLoaded deserialize(JsonObject object, JsonDeserializationContext context) {
            return new IsModLoaded(JSONUtils.func_151200_h((JsonObject)object, (String)"modid"));
        }
    }
}

