/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import mod.schnappdragon.habitat.common.block.FairyRingMushroomBlock;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.util.CompatHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractBigMushroomFeature;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;

public class BigFairyRingMushroomFeature
extends AbstractBigMushroomFeature {
    public BigFairyRingMushroomFeature(Codec<BigMushroomFeatureConfig> codec) {
        super(codec);
    }

    public boolean func_241855_a(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, BigMushroomFeatureConfig config) {
        BlockPos.Mutable blockpos$mutable;
        int i = this.func_227211_a_(rand);
        if (!this.func_227209_a_((IWorld)reader, pos, i, blockpos$mutable = new BlockPos.Mutable(), config)) {
            return false;
        }
        this.func_225564_a_((IWorld)reader, rand, pos, i, blockpos$mutable, config);
        this.func_227210_a_((IWorld)reader, rand, pos, config, i, blockpos$mutable);
        return true;
    }

    protected int func_227211_a_(Random rand) {
        int i = rand.nextInt(2) + 10;
        if (rand.nextInt(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected void func_227210_a_(IWorld world, Random rand, BlockPos pos, BigMushroomFeatureConfig config, int i0, BlockPos.Mutable blockpos$mutable) {
        WeightedBlockStateProvider mushroomProvider = new WeightedBlockStateProvider().func_227407_a_(((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get()).func_176223_P(), 1).func_227407_a_((BlockState)((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get()).func_176223_P().func_206870_a((Property)FairyRingMushroomBlock.MUSHROOMS, (Comparable)Integer.valueOf(2)), 2).func_227407_a_((BlockState)((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get()).func_176223_P().func_206870_a((Property)FairyRingMushroomBlock.MUSHROOMS, (Comparable)Integer.valueOf(3)), 3).func_227407_a_((BlockState)((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get()).func_176223_P().func_206870_a((Property)FairyRingMushroomBlock.MUSHROOMS, (Comparable)Integer.valueOf(4)), 3);
        BlockState stem = config.field_227273_b_.func_225574_a_(rand, pos);
        boolean enhancedFlag = CompatHelper.checkMods("enhanced_mushrooms");
        if (enhancedFlag) {
            stem = ((Block)HabitatBlocks.ENHANCED_FAIRY_RING_MUSHROOM_STEM.get()).func_176223_P();
        }
        block0: for (int i = 0; i < i0; ++i) {
            blockpos$mutable.func_189533_g((Vector3i)pos).func_189534_c(Direction.UP, i);
            if (world.func_180495_p((BlockPos)blockpos$mutable).canBeReplacedByLogs((IWorldReader)world, (BlockPos)blockpos$mutable)) {
                this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$mutable, stem);
            }
            int breakFlag = 0;
            if (i <= i0 - 7) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos.Mutable inPos = new BlockPos.Mutable().func_239621_a_((Vector3i)blockpos$mutable, x, 0, z);
                    if (!world.func_180495_p((BlockPos)inPos).canBeReplacedByLeaves((IWorldReader)world, (BlockPos)inPos) || i <= i0 - 6 || x == 0 && z == 0 || rand.nextInt(12) != 0 || world.func_180495_p(inPos.func_177977_b()).func_203425_a((Block)HabitatBlocks.FAIRYLIGHT.get())) continue;
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)inPos, ((Block)HabitatBlocks.FAIRYLIGHT.get()).func_176223_P());
                    breakFlag = 1;
                    break;
                }
                if (breakFlag != 0) continue block0;
            }
        }
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            int len = rand.nextInt(3) > 0 ? (rand.nextBoolean() ? 1 + MathHelper.func_76123_f((float)((float)rand.nextInt(i0 - 7) / 2.0f)) : MathHelper.func_76123_f((float)((float)rand.nextInt(i0 - 7) / 2.0f))) : 0;
            blockpos$mutable.func_239621_a_((Vector3i)pos, dir.func_82601_c(), -1, dir.func_82599_e());
            for (int i = 0; i < len + 1; ++i) {
                blockpos$mutable.func_189536_c(Direction.UP);
                if (!world.func_180495_p((BlockPos)blockpos$mutable).canBeReplacedByLogs((IWorldReader)world, (BlockPos)blockpos$mutable) || !world.func_180495_p(blockpos$mutable.func_177977_b()).func_200015_d((IBlockReader)world, blockpos$mutable.func_177977_b())) continue;
                if (i < len) {
                    BlockState stemState = stem;
                    if (stemState.func_177230_c() instanceof HugeMushroomBlock) {
                        stemState = (BlockState)stemState.func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(i == len - 1));
                        if (world.func_180495_p(blockpos$mutable.func_177972_a(dir.func_176734_d())).func_203425_a(stemState.func_177230_c())) {
                            stemState = (BlockState)stemState.func_206870_a((Property)this.getPropertyFromDirection(dir.func_176734_d()), (Comparable)Boolean.valueOf(false));
                            this.func_230367_a_((IWorldWriter)world, blockpos$mutable.func_177972_a(dir.func_176734_d()), (BlockState)world.func_180495_p(blockpos$mutable.func_177972_a(dir.func_176734_d())).func_206870_a((Property)this.getPropertyFromDirection(dir), (Comparable)Boolean.valueOf(false)));
                        }
                    }
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$mutable, stemState);
                    continue;
                }
                if (rand.nextInt(3) != 0) continue;
                this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$mutable, mushroomProvider.func_225574_a_(rand, (BlockPos)blockpos$mutable));
            }
        }
        for (int i = -1; i <= 1; i += 2) {
            block6: for (int k = -1; k <= 1; k += 2) {
                for (int j = -1; j <= 1; ++j) {
                    blockpos$mutable.func_239621_a_((Vector3i)pos, i, j, k);
                    if (!world.func_180495_p((BlockPos)blockpos$mutable).isAir((IBlockReader)world, (BlockPos)blockpos$mutable) || !world.func_180495_p(blockpos$mutable.func_177977_b()).func_200015_d((IBlockReader)world, blockpos$mutable.func_177977_b())) continue;
                    if (rand.nextInt(3) != 0) continue block6;
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$mutable, mushroomProvider.func_225574_a_(rand, (BlockPos)blockpos$mutable));
                    continue block6;
                }
            }
        }
    }

    private BooleanProperty getPropertyFromDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return HugeMushroomBlock.field_196459_a;
            }
            case EAST: {
                return HugeMushroomBlock.field_196461_b;
            }
            case SOUTH: {
                return HugeMushroomBlock.field_196463_c;
            }
        }
        return HugeMushroomBlock.field_196464_y;
    }

    protected void func_225564_a_(IWorld world, Random rand, BlockPos pos, int i0, BlockPos.Mutable blockpos$mutable, BigMushroomFeatureConfig config) {
        for (int i = i0 - 6; i <= i0; ++i) {
            int j = i < i0 ? config.field_227274_c_ : config.field_227274_c_ - 1;
            int k = config.field_227274_c_ - 2;
            for (int l = -j; l <= j; ++l) {
                for (int i1 = -j; i1 <= j; ++i1) {
                    boolean flag5;
                    boolean flag = l == -j;
                    boolean flag1 = l == j;
                    boolean flag2 = i1 == -j;
                    boolean flag3 = i1 == j;
                    boolean flag4 = flag || flag1;
                    boolean bl = flag5 = flag2 || flag3;
                    if (i < i0 && flag4 == flag5) continue;
                    blockpos$mutable.func_239621_a_((Vector3i)pos, l, i, i1);
                    if (!world.func_180495_p((BlockPos)blockpos$mutable).canBeReplacedByLeaves((IWorldReader)world, (BlockPos)blockpos$mutable)) continue;
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)blockpos$mutable, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.field_227272_a_.func_225574_a_(rand, pos).func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(i >= i0 - 1))).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(l < -k))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(l > k))).func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(i1 < -k))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(i1 > k)));
                }
            }
        }
    }

    protected int func_225563_a_(int i1, int i2, int i3, int i4) {
        return i4 < i2 && i4 >= i2 - 3 || i4 == i2 ? i3 : 0;
    }
}

