/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class HabitatConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<String> suspiciousStewEffects;
        public final ForgeConfigSpec.ConfigValue<String> pookaPositiveEffects;
        public final ForgeConfigSpec.ConfigValue<String> pookaNegativeEffects;
        public final ForgeConfigSpec.ConfigValue<Integer> rafflesiaChance;
        public final ForgeConfigSpec.ConfigValue<Integer> kabloomBushChance;
        public final ForgeConfigSpec.ConfigValue<Integer> slimeFernChance;
        public final ForgeConfigSpec.ConfigValue<Integer> ballCactusChance;
        public final ForgeConfigSpec.ConfigValue<Integer> fairyRingAverage;
        public final ForgeConfigSpec.ConfigValue<Integer> fairyRingMinimum;
        public final ForgeConfigSpec.ConfigValue<String> rafflesiaWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> kabloomBushWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> slimeFernWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> ballCactusWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> fairyRingWhitelist;
        public final ForgeConfigSpec.ConfigValue<String> rafflesiaBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> kabloomBushBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> slimeFernBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> ballCactusBlacklist;
        public final ForgeConfigSpec.ConfigValue<String> fairyRingBlacklist;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common Configurations for Habitat").push("common");
            builder.comment("\n[MISC]\n");
            builder.comment("\nPooka and Fairy Ring Mushroom Stew Effects\nEnter them in the format effectid:duration (duration in seconds) and separate theme with a single ,");
            this.suspiciousStewEffects = builder.define("suspicious_stew_effects", (Object)"1:12,5:8,8:16,10:10,11:8,2:8,15:12,17:16,18:8,19:10");
            this.pookaPositiveEffects = builder.define("pooka_positive_effects", (Object)"1:6,5:4,8:8,10:5,11:4");
            this.pookaNegativeEffects = builder.define("pooka_negative_effects", (Object)"2:4,15:6,17:8,18:4,19:5");
            builder.comment("\n[WORLDGEN]\n");
            builder.comment("\nFeatures have 1 in X Chance of Generating per Chunk where X is the Config Value");
            this.rafflesiaChance = builder.define("rafflesia_chance", (Object)3);
            this.kabloomBushChance = builder.define("kabloom_bush_chance", (Object)144);
            this.slimeFernChance = builder.define("slime_fern_chance", (Object)2);
            this.ballCactusChance = builder.define("ball_cactus_chance", (Object)14);
            builder.comment("Average and Minimum Chunk Spacing for Structures (Minimum must be lower than Average)");
            this.fairyRingAverage = builder.define("fairy_ring_average", (Object)24);
            this.fairyRingMinimum = builder.define("fairy_ring_minimum", (Object)4);
            builder.comment("Whitelist and Blacklist for Biomes in which Features and Structures can generate\nUse the Biome Name with Namespace (namespace:biome) and separate Biomes if more than one with a single ,\nBiome Whitelist");
            this.rafflesiaWhitelist = builder.define("rafflesia_whitelist", (Object)"");
            this.kabloomBushWhitelist = builder.define("kabloom_bush_whitelist", (Object)"");
            this.slimeFernWhitelist = builder.define("slime_fern_whitelist", (Object)"");
            this.ballCactusWhitelist = builder.define("ball_cactus_whitelist", (Object)"");
            this.fairyRingWhitelist = builder.define("fairy_ring_whitelist", (Object)"");
            builder.comment("Biome Blacklist");
            this.rafflesiaBlacklist = builder.define("rafflesia_blacklist", (Object)"");
            this.kabloomBushBlacklist = builder.define("kabloom_bush_blacklist", (Object)"");
            this.slimeFernBlacklist = builder.define("slime_fern_blacklist", (Object)"");
            this.ballCactusBlacklist = builder.define("ball_cactus_blacklist", (Object)"");
            this.fairyRingBlacklist = builder.define("fairy_ring_blacklist", (Object)"");
            builder.pop();
        }
    }
}

