/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.dispenser;

import mod.schnappdragon.habitat.common.block.FairyRingMushroomBlock;
import mod.schnappdragon.habitat.common.block.FloweringBallCactusBlock;
import mod.schnappdragon.habitat.common.block.KabloomBushBlock;
import mod.schnappdragon.habitat.common.block.RafflesiaBlock;
import mod.schnappdragon.habitat.common.entity.item.HabitatBoatEntity;
import mod.schnappdragon.habitat.common.entity.monster.PookaEntity;
import mod.schnappdragon.habitat.common.entity.projectile.KabloomFruitEntity;
import mod.schnappdragon.habitat.common.item.HabitatSpawnEggItem;
import mod.schnappdragon.habitat.common.tileentity.RafflesiaTileEntity;
import mod.schnappdragon.habitat.core.dispenser.HabitatDispenseBoatBehavior;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HabitatDispenserBehaviours {
    private static IDispenseItemBehavior SuspiciousStewBehavior;
    private static IDispenseItemBehavior ShearsBehavior;
    private static IDispenseItemBehavior RedstoneBehavior;

    public static void registerDispenserBehaviour() {
        SuspiciousStewBehavior = (IDispenseItemBehavior)DispenserBlock.field_149943_a.get(Items.field_222115_pz);
        ShearsBehavior = (IDispenseItemBehavior)DispenserBlock.field_149943_a.get(Items.field_151097_aZ);
        RedstoneBehavior = (IDispenseItemBehavior)DispenserBlock.field_149943_a.get(Items.field_151137_ax);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)HabitatItems.FAIRY_RING_MUSHROOM_BOAT.get()), (IDispenseItemBehavior)new HabitatDispenseBoatBehavior(HabitatBoatEntity.Type.FAIRY_RING_MUSHROOM));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_222115_pz, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld worldIn = source.func_197524_h();
                BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                BlockState state = worldIn.func_180495_p(pos);
                if (!worldIn.field_72995_K && state.func_203425_a((Block)HabitatBlocks.RAFFLESIA.get())) {
                    TileEntity tile = worldIn.func_175625_s(pos);
                    if (tile instanceof RafflesiaTileEntity && !((Boolean)state.func_177229_b((Property)RafflesiaBlock.HAS_STEW)).booleanValue()) {
                        RafflesiaTileEntity rafflesia = (RafflesiaTileEntity)tile;
                        CompoundNBT tag = stack.func_77978_p();
                        if (tag != null && tag.func_150297_b("Effects", 9)) {
                            rafflesia.Effects = tag.func_150295_c("Effects", 10);
                        }
                        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)RafflesiaBlock.HAS_STEW, (Comparable)Boolean.valueOf(true)));
                        rafflesia.onChange((World)worldIn, worldIn.func_180495_p(pos));
                        worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_RAFFLESIA_SLURP.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                        stack = new ItemStack((IItemProvider)Items.field_151054_z, 1);
                        this.func_239796_a_(true);
                        return stack;
                    }
                } else if (SuspiciousStewBehavior != null) {
                    SuspiciousStewBehavior.dispense(source, stack);
                }
                this.func_239796_a_(false);
                return stack;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151097_aZ, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld worldIn = source.func_197524_h();
                BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                BlockState state = worldIn.func_180495_p(pos);
                if (worldIn.field_72995_K) return ShearsBehavior.dispense(source, stack);
                for (PookaEntity pooka : worldIn.func_175647_a(PookaEntity.class, new AxisAlignedBB(pos), EntityPredicates.field_180132_d)) {
                    if (!pooka.isPacified()) continue;
                    worldIn.func_217384_a(null, (Entity)pooka, (SoundEvent)HabitatSoundEvents.ENTITY_POOKA_SHEAR.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                    worldIn.func_195598_a((IParticleData)ParticleTypes.field_197627_t, pooka.func_226277_ct_(), pooka.func_226283_e_(0.5), pooka.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
                    pooka.func_70106_y();
                    worldIn.func_217376_c((Entity)PookaEntity.convertPooka(pooka));
                    worldIn.func_217376_c((Entity)new ItemEntity((World)worldIn, pooka.func_226277_ct_(), pooka.func_226283_e_(1.0), pooka.func_226281_cx_(), new ItemStack((IItemProvider)HabitatItems.FAIRY_RING_MUSHROOM.get())));
                    if (stack.func_96631_a(1, worldIn.func_201674_k(), null)) {
                        stack.func_190920_e(0);
                    }
                    this.func_239796_a_(true);
                    return stack;
                }
                if (state.func_203425_a((Block)HabitatBlocks.KABLOOM_BUSH.get()) && (Integer)state.func_177229_b((Property)KabloomBushBlock.AGE) == 7) {
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)HabitatItems.KABLOOM_FRUIT.get()));
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)KabloomBushBlock.AGE, (Comparable)Integer.valueOf(3)));
                    worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_KABLOOM_BUSH_SHEAR.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                    if (stack.func_96631_a(1, worldIn.func_201674_k(), null)) {
                        stack.func_190920_e(0);
                    }
                    this.func_239796_a_(true);
                    return stack;
                } else if (state.func_177230_c() instanceof FloweringBallCactusBlock) {
                    FloweringBallCactusBlock cactus = (FloweringBallCactusBlock)state.func_177230_c();
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)cactus.getColor().getFlower()));
                    worldIn.func_175656_a(pos, cactus.getColor().getBallCactus().func_176223_P());
                    worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_FLOWERING_BALL_CACTUS_SHEAR.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                    if (stack.func_96631_a(1, worldIn.func_201674_k(), null)) {
                        stack.func_190920_e(0);
                    }
                    this.func_239796_a_(true);
                    return stack;
                } else {
                    if (!state.func_203425_a((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get()) || (Integer)state.func_177229_b((Property)FairyRingMushroomBlock.MUSHROOMS) <= 1) return ShearsBehavior.dispense(source, stack);
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)state.func_177230_c()));
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FairyRingMushroomBlock.MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)FairyRingMushroomBlock.MUSHROOMS) - 1)));
                    worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_FAIRY_RING_MUSHROOM_SHEAR.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                    if (stack.func_96631_a(1, worldIn.func_201674_k(), null)) {
                        stack.func_190920_e(0);
                    }
                    this.func_239796_a_(true);
                }
                return stack;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)HabitatItems.KABLOOM_FRUIT.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return (ProjectileEntity)Util.func_200696_a((Object)((Object)new KabloomFruitEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c())), kabloomfruit -> kabloomfruit.func_213884_b(stackIn));
            }

            protected float func_82498_a() {
                return super.func_82498_a() * 0.9f;
            }

            protected float func_82500_b() {
                return super.func_82500_b() * 0.5f;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151137_ax, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld worldIn = source.func_197524_h();
                BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                BlockState state = worldIn.func_180495_p(pos);
                if (!worldIn.field_72995_K && state.func_203425_a((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get()) && !((Boolean)state.func_177229_b((Property)FairyRingMushroomBlock.DUSTED)).booleanValue()) {
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FairyRingMushroomBlock.DUSTED, (Comparable)Boolean.valueOf(true)));
                    worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                    worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_FAIRY_RING_MUSHROOM_DUST.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                    stack.func_190918_g(1);
                    this.func_239796_a_(true);
                    return stack;
                }
                if (RedstoneBehavior != null) {
                    RedstoneBehavior.dispense(source, stack);
                }
                this.func_239796_a_(false);
                return stack;
            }
        });
        for (SpawnEggItem spawnEggItem : HabitatSpawnEggItem.HABITAT_EGGS) {
            DispenserBlock.func_199774_a((IItemProvider)spawnEggItem, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

                protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                    EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                    entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                    stack.func_190918_g(1);
                    return stack;
                }
            });
        }
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)HabitatItems.FAIRY_RING_MUSHROOM.get()), (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld worldIn = source.func_197524_h();
                if (!worldIn.field_72995_K) {
                    BlockPos pos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                    for (LivingEntity livingentity : worldIn.func_175647_a(LivingEntity.class, new AxisAlignedBB(pos), EntityPredicates.field_180132_d)) {
                        if (livingentity.func_200600_R() != EntityType.field_200736_ab) continue;
                        RabbitEntity rabbit = (RabbitEntity)livingentity;
                        rabbit.func_184185_a((SoundEvent)HabitatSoundEvents.ENTITY_RABBIT_CONVERTED_TO_POOKA.get(), 1.0f, rabbit.func_70631_g_() ? (rabbit.func_70681_au().nextFloat() - rabbit.func_70681_au().nextFloat()) * 0.2f + 1.5f : (rabbit.func_70681_au().nextFloat() - rabbit.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                        rabbit.func_70106_y();
                        worldIn.func_217376_c((Entity)PookaEntity.convertRabbit(rabbit));
                        stack.func_190918_g(1);
                        for (int j = 0; j < 8; ++j) {
                            worldIn.func_195598_a((IParticleData)HabitatParticleTypes.FAIRY_RING_SPORE.get(), rabbit.func_226282_d_(0.5), rabbit.func_226283_e_(0.5), rabbit.func_226287_g_(0.5), 0, rabbit.func_70681_au().nextGaussian(), 0.0, rabbit.func_70681_au().nextGaussian(), 0.01);
                        }
                        this.func_239796_a_(true);
                        return stack;
                    }
                }
                return stack;
            }
        });
    }
}

