/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.event;

import mod.schnappdragon.habitat.common.entity.ai.goal.HabitatFindPollinationTargetGoal;
import mod.schnappdragon.habitat.common.entity.ai.goal.RabbitAvoidEntityGoal;
import mod.schnappdragon.habitat.common.entity.monster.PookaEntity;
import mod.schnappdragon.habitat.core.registry.HabitatEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="habitat")
public class HabitatEvents {
    @SubscribeEvent
    public static void addGoals(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.func_200600_R() == EntityType.field_226289_e_) {
            BeeEntity bee = (BeeEntity)entity;
            bee.field_70714_bg.func_75776_a(7, (Goal)new HabitatFindPollinationTargetGoal(bee));
        } else if (entity.func_200600_R() == EntityType.field_200736_ab) {
            RabbitEntity rabbit = (RabbitEntity)entity;
            rabbit.field_70714_bg.func_75776_a(4, new RabbitAvoidEntityGoal<PookaEntity>(rabbit, PookaEntity.class, 2.25f, 2.2, 2.2));
        }
    }

    @SubscribeEvent
    public static void reduceExplosionDamage(LivingDamageEvent event) {
        if (event.getEntityLiving().func_70644_a((Effect)HabitatEffects.BLAST_ENDURANCE.get()) && event.getSource().func_94541_c()) {
            LivingEntity livingEntity = event.getEntityLiving();
            DamageSource source = event.getSource();
            int lvl = Math.min(livingEntity.func_70660_b((Effect)HabitatEffects.BLAST_ENDURANCE.get()).func_76458_c(), 11);
            float dmg = MathHelper.func_76141_d((float)(event.getAmount() * (0.88f - 0.08f * (float)lvl)));
            int res = (int)(event.getAmount() - dmg);
            event.setAmount(dmg);
            if (livingEntity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)livingEntity).func_195067_a(Stats.field_212739_K, res * 10);
            } else if (source.func_76346_g() instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)source.func_76346_g()).func_195067_a(Stats.field_212736_G, res * 10);
            }
        }
    }

    @SubscribeEvent
    public static void causePricklingDamage(LivingHurtEvent event) {
        if (event.getEntityLiving().func_70644_a((Effect)HabitatEffects.PRICKLING.get())) {
            LivingEntity livingEntity = event.getEntityLiving();
            DamageSource source = event.getSource();
            int lvl = livingEntity.func_70660_b((Effect)HabitatEffects.PRICKLING.get()).func_76458_c();
            if (livingEntity.func_70681_au().nextInt(4) < 2 + lvl && !source.func_82725_o() && !source.func_94541_c() && source.func_76364_f() instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)source.func_76364_f();
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)livingEntity), 1.0f + (float)(lvl > 0 ? livingEntity.func_70681_au().nextInt(lvl) : 0));
            }
        }
    }
}

