/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import mod.schnappdragon.habitat.common.block.SlimeFernBlock;
import mod.schnappdragon.habitat.common.block.WallSlimeFernBlock;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractSlimeFernBlock
extends Block
implements BonemealableBlock {
    public AbstractSlimeFernBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_7100_(BlockState state, Level worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0) {
            VoxelShape voxelshape = this.m_5940_(state, (BlockGetter)worldIn, pos, CollisionContext.m_82749_());
            Vec3 vector3d = voxelshape.m_83215_().m_82399_();
            double X = (double)pos.m_123341_() + vector3d.f_82479_;
            double Y = (double)pos.m_123342_() + vector3d.f_82480_;
            double Z = (double)pos.m_123343_() + vector3d.f_82481_;
            worldIn.m_7106_((ParticleOptions)HabitatParticleTypes.FALLING_SLIME.get(), X + (2.0 * rand.nextDouble() - 1.0) / 2.5, Y - rand.nextDouble() / 5.0, Z + (2.0 * rand.nextDouble() - 1.0) / 2.5, 0.0, 0.0, 0.0);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        double motionY;
        if (entityIn.m_6095_() != EntityType.f_20526_ && (motionY = Math.abs(entityIn.m_20184_().f_82480_)) < 0.1 && !entityIn.m_20161_()) {
            double slowedMotion = 0.4 + motionY * 0.2;
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(slowedMotion, 1.0, slowedMotion));
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        if (!isClient) {
            ChunkPos chunkPos = new ChunkPos(pos);
            return WorldgenRandom.m_64685_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)((WorldGenLevel)worldIn).m_7328_(), (long)987234911L).nextInt(10) == 0;
        }
        return false;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        Direction[] directions = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
        block0: for (int j = 0; j < 3; ++j) {
            blockpos$mutable.m_122154_((Vec3i)pos, Mth.m_14072_((Random)rand, (int)1, (int)2) - Mth.m_14072_((Random)rand, (int)1, (int)2), Mth.m_14072_((Random)rand, (int)1, (int)2) - Mth.m_14072_((Random)rand, (int)1, (int)2), Mth.m_14072_((Random)rand, (int)1, (int)2) - Mth.m_14072_((Random)rand, (int)1, (int)2));
            if (!worldIn.m_46859_((BlockPos)blockpos$mutable) && !worldIn.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76336_()) continue;
            for (Direction dir : directions) {
                if (!worldIn.m_8055_(blockpos$mutable.m_142300_(dir)).m_60783_((BlockGetter)worldIn, (BlockPos)blockpos$mutable, dir.m_122424_())) continue;
                BlockState state1 = ((Block)HabitatBlocks.SLIME_FERN.get()).m_49966_();
                if (dir == Direction.UP) {
                    state1 = (BlockState)state1.m_61124_((Property)SlimeFernBlock.ON_CEILING, (Comparable)Boolean.valueOf(true));
                } else if (dir != Direction.DOWN) {
                    state1 = (BlockState)((Block)HabitatBlocks.WALL_SLIME_FERN.get()).m_49966_().m_61124_((Property)WallSlimeFernBlock.HORIZONTAL_FACING, (Comparable)dir.m_122424_());
                }
                worldIn.m_7731_((BlockPos)blockpos$mutable, state1, 3);
                continue block0;
            }
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }
}

