/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import mod.schnappdragon.habitat.common.block.state.properties.HabitatBlockStateProperties;
import mod.schnappdragon.habitat.common.entity.monster.Pooka;
import mod.schnappdragon.habitat.core.registry.HabitatConfiguredFeatures;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class FairyRingMushroomBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape[] SHAPE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final IntegerProperty MUSHROOMS = HabitatBlockStateProperties.MUSHROOMS_1_4;
    public static final BooleanProperty DUSTED = HabitatBlockStateProperties.DUSTED;

    public FairyRingMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf(1))).m_61124_((Property)DUSTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MUSHROOMS, DUSTED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE[(Integer)state.m_61143_((Property)MUSHROOMS) - 1];
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)worldIn, pos.m_7495_());
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.m_6095_() == EntityType.f_20517_ && entityIn.m_6084_()) {
            Rabbit rabbit = (Rabbit)entityIn;
            rabbit.m_5496_((SoundEvent)HabitatSoundEvents.RABBIT_CONVERTED_TO_POOKA.get(), 1.0f, rabbit.m_6162_() ? (rabbit.m_21187_().nextFloat() - rabbit.m_21187_().nextFloat()) * 0.2f + 1.5f : (rabbit.m_21187_().nextFloat() - rabbit.m_21187_().nextFloat()) * 0.2f + 1.0f);
            rabbit.m_146870_();
            worldIn.m_7967_((Entity)Pooka.convertRabbitToPooka(rabbit));
            for (int i = 0; i < 8; ++i) {
                ((ServerLevel)worldIn).m_8767_((ParticleOptions)((SimpleParticleType)HabitatParticleTypes.FAIRY_RING_SPORE.get()), rabbit.m_20208_(0.5), rabbit.m_20227_(0.5), rabbit.m_20262_(0.5), 0, rabbit.m_21187_().nextGaussian(), 0.0, rabbit.m_21187_().nextGaussian(), 0.01);
            }
        }
    }

    public void m_7100_(BlockState state, Level worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)DUSTED)).booleanValue() && rand.nextInt(18 - 2 * (Integer)state.m_61143_((Property)MUSHROOMS)) == 0) {
            worldIn.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + rand.nextDouble(), (double)pos.m_123343_() + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
        if (rand.nextInt(9 - (Integer)state.m_61143_((Property)MUSHROOMS)) == 0) {
            worldIn.m_7106_((ParticleOptions)HabitatParticleTypes.FAIRY_RING_SPORE.get(), (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + rand.nextDouble(), (double)pos.m_123343_() + rand.nextDouble(), rand.nextGaussian() * 0.01, 0.0, rand.nextGaussian() * 0.01);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_41720_() instanceof ShearsItem && (Integer)state.m_61143_((Property)MUSHROOMS) > 1) {
            FairyRingMushroomBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.m_49966_().m_60734_()));
            player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
            worldIn.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)MUSHROOMS) - 1)), 2);
            worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.FAIRY_RING_MUSHROOM_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.nextFloat() * 0.4f);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (player.m_21120_(handIn).m_41720_() == HabitatItems.FAIRY_RING_MUSHROOM.get() && (Integer)state.m_61143_((Property)MUSHROOMS) < 4) {
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(handIn).m_41774_(1);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)MUSHROOMS) + 1)), 2);
            worldIn.m_5594_(null, pos, SoundType.f_56740_.m_56777_(), SoundSource.BLOCKS, SoundType.f_56740_.m_56773_() + 0.5f, SoundType.f_56740_.m_56774_() * 0.8f);
            worldIn.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (player.m_21120_(handIn).m_41720_() == Items.f_42451_ && !((Boolean)state.m_61143_((Property)DUSTED)).booleanValue()) {
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(handIn).m_41774_(1);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)DUSTED, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.FAIRY_RING_MUSHROOM_DUST.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.nextFloat() * 0.4f);
            worldIn.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public int m_6378_(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)DUSTED) != false ? (Integer)state.m_61143_((Property)MUSHROOMS) : 0;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)MUSHROOMS) < 4 && (Boolean)state.m_61143_((Property)DUSTED) == false;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if ((Integer)state.m_61143_((Property)MUSHROOMS) < 4 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(25) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)MUSHROOMS) + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)DUSTED) == false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        if ((Boolean)state.m_61143_((Property)DUSTED) != false) return false;
        if ((Integer)state.m_61143_((Property)MUSHROOMS) != 4) return true;
        float f = rand.nextFloat();
        float f2 = worldIn.m_8055_(pos.m_7495_()).m_60620_((Tag)BlockTags.f_13057_) ? 0.8f : 0.4f;
        if (!(f < f2)) return false;
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)MUSHROOMS) < 4) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)MUSHROOMS, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.m_61143_((Property)MUSHROOMS) + Mth.m_14072_((Random)rand, (int)1, (int)2)))), 2);
        } else {
            this.growHugeMushroom(worldIn, rand, pos, state);
        }
    }

    private void growHugeMushroom(ServerLevel world, Random rand, BlockPos pos, BlockState state) {
        world.m_7471_(pos, false);
        ConfiguredFeature<?, ?> configuredfeature = HabitatConfiguredFeatures.HUGE_FAIRY_RING_MUSHROOM;
        if (!configuredfeature.m_65385_((WorldGenLevel)world, world.m_7726_().m_8481_(), rand, pos)) {
            world.m_7731_(pos, state, 3);
        }
    }
}

