/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.entity.projectile.ThrownKabloomFruit;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KabloomFruitPileBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public KabloomFruitPileBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        this.explode(worldIn, pos, true, false);
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        this.explode(worldIn, hitResult.m_82425_(), true, false);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        this.explode(worldIn, pos, true, false);
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void catchFire(BlockState state, Level worldIn, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.explode(worldIn, pos, true, true);
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        this.explode(worldIn, pos, false, false);
    }

    public void m_8101_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack) {
        super.m_8101_(state, worldIn, pos, stack);
        if (worldIn.m_46469_().m_46207_(GameRules.f_46136_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 0) {
            this.explode((Level)worldIn, pos, false, false);
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    private void explode(Level worldIn, BlockPos pos, boolean destroyBlock, boolean setFire) {
        if (!worldIn.f_46443_) {
            if (destroyBlock) {
                worldIn.m_46961_(pos, false);
            }
            worldIn.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)HabitatSoundEvents.KABLOOM_FRUIT_EXPLODE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + (worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.2f, true);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 1.0, 0.0, 0.0);
            for (int i = 1; i <= 9; ++i) {
                ThrownKabloomFruit kabloom = new ThrownKabloomFruit(worldIn, (float)pos.m_123341_() + worldIn.f_46441_.nextFloat(), (float)pos.m_123342_() + worldIn.f_46441_.nextFloat(), (float)pos.m_123343_() + worldIn.f_46441_.nextFloat());
                if (setFire) {
                    kabloom.m_20254_(8);
                }
                worldIn.m_7967_((Entity)kabloom);
            }
        }
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.DANGER_OTHER;
    }
}

