/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.animal;

import com.mojang.math.Vector3f;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.core.misc.HabitatDamageSources;
import mod.schnappdragon.habitat.core.particles.FeatherParticleOptions;
import mod.schnappdragon.habitat.core.particles.NoteParticleOptions;
import mod.schnappdragon.habitat.core.registry.HabitatCriterionTriggers;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.tags.HabitatBlockTags;
import mod.schnappdragon.habitat.core.tags.HabitatItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Passerine
extends Animal
implements FlyingAnimal {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(Passerine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_SLEEPING = SynchedEntityData.m_135353_(Passerine.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float flap;
    public float flapSpeed;
    public float initialFlapSpeed;
    public float initialFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    private int animationTick;
    private PreenGoal preenGoal;

    public Passerine(EntityType<? extends Passerine> passerine, Level worldIn) {
        super(passerine, worldIn);
        this.f_21342_ = new PasserineMoveControl(10, false);
        this.f_21365_ = new PasserineLookControl();
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new PasserineTemptGoal(1.0, Ingredient.m_43911_(HabitatItemTags.PASSERINE_FOOD), false));
        this.f_21345_.m_25352_(3, (Goal)new FindCoverGoal(1.25));
        this.f_21345_.m_25352_(4, (Goal)new SleepGoal());
        this.preenGoal = new PreenGoal();
        this.f_21345_.m_25352_(5, (Goal)this.preenGoal);
        this.f_21345_.m_25352_(6, (Goal)new PasserineRandomFlyingGoal(1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new PasserineFollowMobGoal(1.0, 3.0f, 7.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, (double)0.8f).m_22268_(Attributes.f_22279_, (double)0.16f);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.5f * this.m_20192_()), (double)(this.m_20205_() * 0.3f));
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_SLEEPING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Sleeping", this.m_5803_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setSleeping(compound.m_128471_("Sleeping"));
    }

    public void setVariant(int id) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)id);
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID)), (int)0, (int)9);
    }

    public void setSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(DATA_SLEEPING, (Object)isSleeping);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SLEEPING);
    }

    protected void m_8024_() {
        this.animationTick = this.preenGoal.getAnimationTick();
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        if (this.f_19853_.f_46443_ && this.animationTick > 0) {
            --this.animationTick;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_5803_() && (this.m_142592_() || this.f_19853_.m_46461_() || this.isUnsafeAt(this.m_142538_()) || !this.canPerch())) {
            this.setSleeping(false);
        }
    }

    public boolean isPreening() {
        return this.animationTick > 0;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    private boolean isNotBusy() {
        return !this.m_5803_() && !this.isPreening();
    }

    private boolean isUnsafeAt(BlockPos pos) {
        if (this.isGoldfish() || !this.f_19853_.m_46471_() || !this.f_19853_.m_45527_(pos)) {
            return false;
        }
        if (this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return false;
        }
        return this.f_19853_.m_46857_(pos).m_47530_() != Biome.Precipitation.NONE;
    }

    private boolean isActive() {
        return this.f_19853_.m_46461_() && !this.f_19853_.m_46471_();
    }

    private boolean canPerch() {
        return this.f_19853_.m_8055_(this.m_20097_()).m_60620_(HabitatBlockTags.PASSERINE_PERCHABLE);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    private void calculateFlapping() {
        this.initialFlap = this.flap;
        this.initialFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.f_19861_ && !this.m_20159_() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.m_5496_((SoundEvent)HabitatSoundEvents.PASSERINE_FLAP.get(), 0.1f, 1.0f);
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
        if (!this.isEasterEgg() && this.f_19796_.nextInt(30) == 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)11);
        }
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150922_(HabitatItemTags.PASSERINE_FOOD) && this.isNotBusy()) {
            if (!this.f_19853_.f_46443_) {
                this.m_5634_(1.0f);
                this.m_142075_(player, hand, stack);
                this.f_19853_.m_7605_((Entity)this, (byte)13);
                this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                HabitatCriterionTriggers.FEED_PASSERINE.trigger((ServerPlayer)player);
                this.m_5496_((SoundEvent)HabitatSoundEvents.PASSERINE_AMBIENT.get(), 1.0f, this.m_6100_());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int i = this.getVariantByBiome((LevelAccessor)worldIn);
        SpawnGroupData spawnGroupData = spawnDataIn;
        if (spawnGroupData instanceof PasserineGroupData) {
            PasserineGroupData data = (PasserineGroupData)spawnGroupData;
            i = data.variant;
        } else {
            spawnDataIn = new PasserineGroupData(i);
        }
        this.setVariant(i);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public int getVariantByBiome(LevelAccessor worldIn) {
        Biome biome = worldIn.m_46857_(this.m_142538_());
        Optional optional = worldIn.m_45837_(this.m_142538_());
        if (Objects.equals(optional, Optional.of(Biomes.f_48179_))) {
            return this.f_19796_.nextInt(10);
        }
        if (biome.m_47567_() == Biome.BiomeCategory.JUNGLE) {
            return this.f_19796_.nextBoolean() ? 1 : 8;
        }
        if (biome.m_47554_() >= 1.0f) {
            return this.f_19796_.nextBoolean() ? 3 : 6;
        }
        if (biome.m_47554_() < 0.5f) {
            return (new int[]{2, 3, 5, 7})[this.f_19796_.nextInt(4)];
        }
        if (biome.m_47554_() <= 0.6f) {
            return (new int[]{0, 2, 3, 4, 5, 7})[this.f_19796_.nextInt(6)];
        }
        return (new int[]{0, 3, 5, 6, 7, 9})[this.f_19796_.nextInt(6)];
    }

    public static boolean checkPasserineSpawnRules(EntityType<Passerine> type, LevelAccessor worldIn, MobSpawnType spawnType, BlockPos pos, Random random) {
        BlockState state = worldIn.m_8055_(pos.m_7495_());
        return (state.m_60620_(HabitatBlockTags.PASSERINE_PERCHABLE) || state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_50599_) || state.m_60713_(Blocks.f_50016_)) && worldIn.m_45524_(pos, 0) > 8;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && source.m_7640_() != null && !this.isEasterEgg()) {
            this.f_19853_.m_7605_((Entity)this, (byte)12);
        }
        return super.m_6469_(source, amount);
    }

    public void m_8032_() {
        if (!this.isPreening() && this.isActive()) {
            super.m_8032_();
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_7605_((Entity)this, (byte)13);
            }
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)HabitatSoundEvents.PASSERINE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)HabitatSoundEvents.PASSERINE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)HabitatSoundEvents.PASSERINE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)HabitatSoundEvents.PASSERINE_STEP.get(), 0.1f, 1.0f);
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f;
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 11: {
                this.spawnFeathers(this.getFeather(), 1);
                break;
            }
            case 12: {
                this.spawnFeathers(this.getFeather(), 2);
                break;
            }
            case 13: {
                this.f_19853_.m_7106_((ParticleOptions)this.getNote(), this.m_20208_(0.5), 0.6 + this.m_20186_(), this.m_20262_(0.5), this.f_19796_.nextDouble(), 0.0, 0.0);
                break;
            }
            case 14: {
                this.animationTick = 40;
                break;
            }
            case 15: {
                this.animationTick = 0;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    protected void spawnFeathers(FeatherParticleOptions feather, int number) {
        for (int i = 0; i < number; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)feather, this.m_20208_(0.5), this.m_20227_(this.f_19796_.nextDouble() * 0.75), this.m_20262_(0.5), this.f_19796_.nextGaussian() * 0.01, 0.0, this.f_19796_.nextGaussian() * 0.01);
        }
    }

    private FeatherParticleOptions getFeather() {
        return Variant.getFeatherByVariant(this.getVariant());
    }

    private NoteParticleOptions getNote() {
        return Variant.getNoteByVariant(this.getVariant());
    }

    public boolean isEasterEgg() {
        return this.isBerdly() || this.isGoldfish() || this.isTurkey();
    }

    public boolean isBerdly() {
        return "Berdly".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()));
    }

    public boolean isGoldfish() {
        return this.getVariant() == 0 && "Goldfish".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()));
    }

    public boolean isTurkey() {
        return "Turkey".equals(ChatFormatting.m_126649_((String)this.m_7755_().getString()));
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.f_19853_.f_46443_ && this.f_20890_ && this.isBerdly() && source == DamageSource.f_146701_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_)) {
            this.m_21231_().m_19289_(HabitatDamageSources.SNOWGRAVE, this.m_21223_(), this.m_21233_());
            ((ServerLevel)this.f_19853_).m_142572_().m_6846_().m_11264_(this.m_21231_().m_19293_(), ChatType.SYSTEM, Util.f_137441_);
        }
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    @Nullable
    public Passerine getBreedOffspring(ServerLevel worldIn, AgeableMob passerine) {
        return null;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_142535_(float f, float f1, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pps) {
    }

    public class PasserineMoveControl
    extends FlyingMoveControl {
        public PasserineMoveControl(int maxTurns, boolean hoversInPlace) {
            super((Mob)Passerine.this, maxTurns, hoversInPlace);
        }

        public void m_8126_() {
            if (Passerine.this.isNotBusy()) {
                super.m_8126_();
            }
        }
    }

    public class PasserineLookControl
    extends LookControl {
        public PasserineLookControl() {
            super((Mob)Passerine.this);
        }

        public void m_8128_() {
            if (Passerine.this.isNotBusy()) {
                super.m_8128_();
            }
        }
    }

    class PasserineTemptGoal
    extends TemptGoal {
        public PasserineTemptGoal(double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)Passerine.this, speedModifier, items, canScare);
        }

        public boolean m_8036_() {
            return !Passerine.this.m_5803_() && super.m_8036_();
        }
    }

    class FindCoverGoal
    extends FleeSunGoal {
        public FindCoverGoal(double speedModifier) {
            super((PathfinderMob)Passerine.this, speedModifier);
        }

        public boolean m_8036_() {
            return Passerine.this.isUnsafeAt(Passerine.this.m_142538_()) && !this.isTargetPosDry() && this.m_25226_();
        }

        private boolean isTargetPosDry() {
            return Passerine.this.m_21573_().m_26572_() && !Passerine.this.isUnsafeAt(Passerine.this.m_21573_().m_26567_());
        }
    }

    class SleepGoal
    extends Goal {
        private int countdown;

        public SleepGoal() {
            this.countdown = Passerine.this.f_19796_.nextInt(140);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Passerine.this.f_20900_ == 0.0f && Passerine.this.f_20901_ == 0.0f && Passerine.this.f_20902_ == 0.0f && (this.canSleep() || Passerine.this.m_5803_());
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            if (Passerine.this.m_142592_() || Passerine.this.isPreening() || Passerine.this.f_19853_.m_46461_()) {
                return false;
            }
            return Passerine.this.canPerch();
        }

        public void m_8056_() {
            Passerine.this.setSleeping(true);
            Passerine.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.countdown = Passerine.this.f_19796_.nextInt(140);
            Passerine.this.setSleeping(false);
        }
    }

    class PreenGoal
    extends Goal {
        private int countdown;
        private int animationTick;

        public PreenGoal() {
            this.countdown = 2800 + Passerine.this.f_19796_.nextInt(2800);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return this.canPreen() || Passerine.this.isPreening();
        }

        public boolean m_8045_() {
            return this.animationTick > 0 && this.canPreen();
        }

        private boolean canPreen() {
            return !Passerine.this.isTurkey() && !Passerine.this.m_142592_() && !Passerine.this.m_5803_();
        }

        public void m_8056_() {
            this.animationTick = 40;
            Passerine.this.m_21573_().m_26573_();
            Passerine.this.f_19853_.m_7605_((Entity)Passerine.this, (byte)14);
        }

        public void m_8041_() {
            this.animationTick = 0;
            this.countdown = 2800 + Passerine.this.f_19796_.nextInt(2800);
            Passerine.this.f_19853_.m_7605_((Entity)Passerine.this, (byte)15);
        }

        public void m_8037_() {
            if (this.animationTick > 0) {
                --this.animationTick;
                if (this.animationTick == 30) {
                    Passerine.this.f_19853_.m_7605_((Entity)Passerine.this, (byte)11);
                }
            }
        }

        public int getAnimationTick() {
            return this.animationTick;
        }
    }

    class PasserineRandomFlyingGoal
    extends WaterAvoidingRandomStrollGoal {
        public PasserineRandomFlyingGoal(double speedModifier) {
            super((PathfinderMob)Passerine.this, speedModifier);
        }

        @Nullable
        protected Vec3 m_7037_() {
            if (Passerine.this.m_20069_() || Passerine.this.isUnsafeAt(Passerine.this.m_142538_())) {
                return LandRandomPos.m_148488_((PathfinderMob)Passerine.this, (int)15, (int)15);
            }
            float probability = Passerine.this.f_19853_.m_46461_() ? this.f_25985_ : 0.0f;
            Vec3 vec3 = Passerine.this.m_21187_().nextFloat() >= probability ? this.getPerchablePos() : null;
            vec3 = vec3 == null ? super.m_7037_() : vec3;
            return vec3 != null && !Passerine.this.isUnsafeAt(new BlockPos(vec3)) ? vec3 : null;
        }

        @Nullable
        private Vec3 getPerchablePos() {
            BlockPos blockpos = Passerine.this.m_142538_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.m_121976_((int)Mth.m_14107_((double)(Passerine.this.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(Passerine.this.m_20189_() + 3.0)))) {
                BlockState state;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (state = Passerine.this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos1, Direction.DOWN))).m_60620_(HabitatBlockTags.PASSERINE_PERCHABLE)) || !Passerine.this.f_19853_.m_46859_(blockpos1) || !Passerine.this.f_19853_.m_46859_((BlockPos)blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    class PasserineFollowMobGoal
    extends FollowMobGoal {
        public PasserineFollowMobGoal(double speedModifier, float stopDistance, float areaSize) {
            super((Mob)Passerine.this, speedModifier, stopDistance, areaSize);
        }

        public boolean m_8036_() {
            return Passerine.this.isActive() && super.m_8036_();
        }
    }

    public static class PasserineGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final int variant;

        public PasserineGroupData(int variantId) {
            super(false);
            this.variant = variantId;
        }
    }

    public static enum Variant {
        AMERICAN_GOLDFINCH(0xF4F111, 0xFFFA00),
        BALI_MYNA(0xFFFFFF, 8703),
        BLUE_JAY(4815308, 24063),
        COMMON_SPARROW(7488818, 16730112),
        EASTERN_BLUEBIRD(5012138, 0xFF7F00),
        EURASIAN_BULLFINCH(796479, 16711726),
        FLAME_ROBIN(6248013, 16739840),
        NORTHERN_CARDINAL(13183262, 0xFF0C00),
        RED_THROATED_PARROTFINCH(4487992, 0xFF0800),
        VIOLET_BACKED_STARLING(6435209, 9175295);

        private static final Variant[] VARIANTS;
        private final FeatherParticleOptions feather;
        private final NoteParticleOptions note;

        private Variant(int featherColor, int noteColor) {
            this.feather = new FeatherParticleOptions(new Vector3f(Vec3.m_82501_((int)featherColor)), 0.33f);
            this.note = new NoteParticleOptions(new Vector3f(Vec3.m_82501_((int)noteColor)), 0.8f);
        }

        public static FeatherParticleOptions getFeatherByVariant(int id) {
            return Variant.getVariantById((int)id).feather;
        }

        public static NoteParticleOptions getNoteByVariant(int id) {
            return Variant.getVariantById((int)id).note;
        }

        private static Variant getVariantById(int id) {
            return VARIANTS[Mth.m_14045_((int)id, (int)0, (int)9)];
        }

        static {
            VARIANTS = Variant.values();
        }
    }
}

