/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.projectile;

import mod.schnappdragon.habitat.core.misc.HabitatDamageSources;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkHooks;

public class ThrownKabloomFruit
extends ThrowableItemProjectile {
    public ThrownKabloomFruit(EntityType<? extends ThrownKabloomFruit> entity, Level world) {
        super(entity, world);
    }

    public ThrownKabloomFruit(Level worldIn, LivingEntity throwerIn) {
        super((EntityType)HabitatEntityTypes.KABLOOM_FRUIT.get(), throwerIn, worldIn);
    }

    public ThrownKabloomFruit(Level worldIn, double x, double y, double z) {
        super((EntityType)HabitatEntityTypes.KABLOOM_FRUIT.get(), x, y, z, worldIn);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6060_()) {
            this.explode(this.m_20182_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)HabitatSoundEvents.KABLOOM_FRUIT_EXPLODE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + (this.f_19853_.f_46441_.nextFloat() - this.f_19853_.f_46441_.nextFloat()) * 0.2f, true);
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.nextFloat() - 0.5) * 0.08, ((double)this.f_19796_.nextFloat() - 0.5) * 0.8, ((double)this.f_19796_.nextFloat() - 0.5) * 0.08);
            }
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        this.explode(result.m_82450_());
    }

    protected Item m_7881_() {
        return (Item)HabitatItems.KABLOOM_FRUIT.get();
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)HabitatItems.KABLOOM_FRUIT.get());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Vec3 m_20133_(Vec3 pos) {
        this.explode(this.m_20182_());
        return Vec3.f_82478_;
    }

    private void explode(Vec3 vector3d) {
        if (!this.f_19853_.f_46443_) {
            this.m_146855_(GameEvent.f_157812_, this.m_37282_(), this.m_142538_());
            for (Entity entity : this.f_19853_.m_45933_(null, this.m_142469_().m_82400_(0.8))) {
                double dz;
                double dy;
                double dx;
                double dres;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(vector3d, new Vec3(entity.m_20185_(), entity.m_20227_(0.5 * (double)i), entity.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                    if (raytraceresult.m_6662_() != HitResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float dmg = 0.0f;
                if (!entity.m_6128_() && (dres = (double)Mth.m_14116_((float)((float)((dx = entity.m_20185_() - this.m_20185_()) * dx + (dy = entity.m_20188_() - this.m_20186_()) * dy + (dz = entity.m_20189_() - this.m_20189_()) * dz)))) != 0.0) {
                    ServerPlayer player;
                    dx /= dres;
                    dy /= dres;
                    dz /= dres;
                    double df = this.m_20270_(entity) > 1.0f ? 0.25 : 0.5;
                    dmg = 4.0f + 4.0f * (float)df;
                    double dred = df;
                    Entity entity2 = entity;
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity2;
                        dred = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)df) * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                    }
                    Vec3 motionVec = entity.m_20184_().m_82520_(dx * dred, dy * dred, dz * dred);
                    entity.m_20256_(motionVec);
                    Entity entity3 = entity;
                    if (!(!(entity3 instanceof ServerPlayer) || (player = (ServerPlayer)entity3).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_)) {
                        player.f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(player.m_142049_(), motionVec));
                    }
                }
                if (entity instanceof LivingEntity) {
                    entity.m_6469_(HabitatDamageSources.causeKabloomDamage(this, this.m_37282_(), true), dmg);
                } else if (entity.m_6097_()) {
                    entity.m_6469_(HabitatDamageSources.causeKabloomDamage(this, this.m_37282_(), false), dmg);
                }
                if (!this.m_6060_() || entity.m_5825_()) continue;
                entity.m_20254_(1);
            }
            if (((GameRules.BooleanValue)this.f_19853_.m_46469_().m_46170_(GameRules.f_46137_)).m_46223_()) {
                ItemEntity item = new ItemEntity(this.f_19853_, vector3d.m_7096_() + this.f_19796_.nextDouble() * (double)(this.f_19796_.nextBoolean() ? 1 : -1) * 0.5, vector3d.m_7098_() + this.f_19796_.nextDouble() / 2.0, vector3d.m_7094_() + this.f_19796_.nextDouble() * (double)(this.f_19796_.nextBoolean() ? 1 : -1) * 0.5, new ItemStack((ItemLike)HabitatItems.KABLOOM_PULP.get()));
                item.m_32060_();
                if (this.m_6060_() && !item.m_5825_()) {
                    item.m_20254_(1);
                }
                this.f_19853_.m_7967_((Entity)item);
            }
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_7605_((Entity)this, (byte)3);
                this.m_146870_();
            }
        }
    }
}

