/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.levelgen.feature.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class FairyRingStructure
extends StructureFeature<NoneFeatureConfiguration> {
    private static final List<MobSpawnSettings.SpawnerData> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnSettings.SpawnerData((EntityType)HabitatEntityTypes.POOKA.get(), 100, 3, 4));

    public FairyRingStructure(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return Start::new;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeSource biomeSource, long seed, WorldgenRandom chunkRandom, ChunkPos chunkPos1, Biome biome, ChunkPos chunkPos2, NoneFeatureConfiguration featureConfig, LevelHeightAccessor accessor) {
        BlockPos centerOfChunk = new BlockPos(chunkPos1.f_45578_ * 16, 0, chunkPos1.f_45579_ * 16);
        int landHeight = chunkGenerator.m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, accessor);
        NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), accessor);
        BlockState topBlock = columnOfBlocks.m_47156_(centerOfChunk.m_6630_(landHeight));
        return topBlock.m_60819_().m_76178_();
    }

    public static class Start
    extends StructureStart<NoneFeatureConfiguration> {
        public Start(StructureFeature<NoneFeatureConfiguration> structure, ChunkPos chunkPos, int reference, long seed) {
            super(structure, chunkPos, reference, seed);
        }

        public void generatePieces(RegistryAccess dynamicRegistryManager, ChunkGenerator chunkGenerator, StructureManager templateManagerIn, ChunkPos chunkPos, Biome biomeIn, NoneFeatureConfiguration config, LevelHeightAccessor accessor) {
            int x = chunkPos.f_45578_ * 16;
            int z = chunkPos.f_45579_ * 16;
            BlockPos centerPos = new BlockPos(x, 0, z);
            JigsawPlacement.m_161612_((RegistryAccess)dynamicRegistryManager, (JigsawConfiguration)new JigsawConfiguration(() -> (StructureTemplatePool)dynamicRegistryManager.m_175515_(Registry.f_122884_).m_7745_(new ResourceLocation("habitat", "fairy_ring/start_pool")), 10), PoolElementStructurePiece::new, (ChunkGenerator)chunkGenerator, (StructureManager)templateManagerIn, (BlockPos)centerPos, (StructurePieceAccessor)this, (Random)this.f_73564_, (boolean)false, (boolean)true, (LevelHeightAccessor)accessor);
            BlockPos structureCenter = ((StructurePiece)this.f_73562_.get(0)).m_73547_().m_162394_();
            int xOffset = centerPos.m_123341_() - structureCenter.m_123341_();
            int zOffset = centerPos.m_123343_() - structureCenter.m_123343_();
            for (StructurePiece structurePiece : this.f_73562_) {
                structurePiece.m_6324_(xOffset, 0, zOffset);
            }
            this.m_142516_();
        }
    }
}

