/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core;

import mod.schnappdragon.habitat.client.renderer.HabitatRenderLayers;
import mod.schnappdragon.habitat.core.HabitatConfig;
import mod.schnappdragon.habitat.core.api.conditions.RecipeConditions;
import mod.schnappdragon.habitat.core.dispenser.HabitatDispenseItemBehavior;
import mod.schnappdragon.habitat.core.misc.HabitatBrewingMixes;
import mod.schnappdragon.habitat.core.misc.HabitatComposterChances;
import mod.schnappdragon.habitat.core.misc.HabitatFireInfo;
import mod.schnappdragon.habitat.core.misc.HabitatPOI;
import mod.schnappdragon.habitat.core.misc.HabitatParrotImitationSounds;
import mod.schnappdragon.habitat.core.misc.HabitatSpawns;
import mod.schnappdragon.habitat.core.registry.HabitatBlockEntityTypes;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.registry.HabitatConfiguredFeatures;
import mod.schnappdragon.habitat.core.registry.HabitatConfiguredStructures;
import mod.schnappdragon.habitat.core.registry.HabitatCriterionTriggers;
import mod.schnappdragon.habitat.core.registry.HabitatEffects;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import mod.schnappdragon.habitat.core.registry.HabitatFeatures;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatLootConditionTypes;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatPotions;
import mod.schnappdragon.habitat.core.registry.HabitatRecipeSerializers;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.registry.HabitatStructures;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="habitat")
public class Habitat {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "habitat";
    public static final boolean DEV = !FMLLoader.isProduction();

    public Habitat() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)HabitatConfig.COMMON_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        HabitatBlocks.BLOCKS.register(modEventBus);
        HabitatItems.ITEMS.register(modEventBus);
        HabitatBlockEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        HabitatSoundEvents.SOUND_EVENTS.register(modEventBus);
        HabitatEntityTypes.ENTITY_TYPES.register(modEventBus);
        HabitatEffects.EFFECTS.register(modEventBus);
        HabitatPotions.POTIONS.register(modEventBus);
        HabitatRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        HabitatFeatures.FEATURES.register(modEventBus);
        HabitatStructures.STRUCTURE_FEATURES.register(modEventBus);
        HabitatParticleTypes.PARTICLE_TYPES.register(modEventBus);
        RecipeConditions.registerSerializers();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HabitatParrotImitationSounds.registerParrotImitationSounds();
            HabitatStructures.setupStructures();
            HabitatBrewingMixes.registerBrewingMixes();
            HabitatConfiguredFeatures.registerConfiguredFeatures();
            HabitatConfiguredStructures.registerConfiguredStructures();
            HabitatComposterChances.registerComposterChances();
            HabitatDispenseItemBehavior.registerDispenserBehaviour();
            HabitatCriterionTriggers.registerCriteriaTriggers();
            HabitatLootConditionTypes.registerLootConditionTypes();
            HabitatFireInfo.registerFireInfo();
            HabitatPOI.addBeehivePOI();
            HabitatSpawns.registerSpawns();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        HabitatRenderLayers.registerRenderLayers();
    }

    public static Logger getLOGGER() {
        return LOGGER;
    }
}

