/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.event.world;

import mod.schnappdragon.habitat.core.registry.HabitatConfiguredFeatures;
import mod.schnappdragon.habitat.core.registry.HabitatConfiguredStructures;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="habitat")
public class HabitatBiomeLoadingEvent {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void modifyBiomes(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            BiomeHelper biome = new BiomeHelper(event);
            if (biome.checkType(BiomeDictionary.Type.OVERWORLD)) {
                biome.addFeature(HabitatConfiguredFeatures.PATCH_SLIME_FERN, GenerationStep.Decoration.UNDERGROUND_DECORATION);
                if (biome.checkKey(Biomes.f_48203_, Biomes.f_48218_, Biomes.f_48159_, Biomes.f_48161_, Biomes.f_48194_, Biomes.f_48196_, Biomes.f_48195_, Biomes.f_48160_)) {
                    biome.addFeature(HabitatConfiguredFeatures.PATCH_BALL_CACTUS, GenerationStep.Decoration.VEGETAL_DECORATION);
                }
                if (biome.checkCategory(Biome.BiomeCategory.FOREST)) {
                    if (biome.checkKey(Biomes.f_48151_, Biomes.f_48187_)) {
                        biome.addStructure(HabitatConfiguredStructures.FAIRY_RING);
                    } else if (biome.checkKey(Biomes.f_48179_)) {
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 20, 3, 4);
                    } else if (!biome.checkType(BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD)) {
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 6, 3, 4);
                    }
                }
                if (biome.checkKey(Biomes.f_48222_, Biomes.f_48224_, Biomes.f_48223_, Biomes.f_48197_, Biomes.f_48198_, Biomes.f_48183_, Biomes.f_48184_)) {
                    if (!biome.checkKey(Biomes.f_48197_, Biomes.f_48198_)) {
                        biome.addFeature(HabitatConfiguredFeatures.PATCH_RAFFLESIA, GenerationStep.Decoration.VEGETAL_DECORATION);
                    }
                    biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 20, 3, 4);
                } else if (biome.checkCategory(Biome.BiomeCategory.JUNGLE)) {
                    biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 3, 3, 4);
                }
                if (biome.checkCategory(Biome.BiomeCategory.PLAINS)) {
                    biome.addFeature(HabitatConfiguredFeatures.PATCH_KABLOOM_BUSH, GenerationStep.Decoration.VEGETAL_DECORATION);
                }
                if (biome.checkCategory(Biome.BiomeCategory.SAVANNA)) {
                    biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 3, 3, 4);
                }
                if (biome.checkCategory(Biome.BiomeCategory.TAIGA)) {
                    biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 6, 3, 4);
                }
            }
        }
    }

    private static class BiomeHelper {
        private final BiomeLoadingEvent event;
        private final BiomeGenerationSettingsBuilder generation;
        private final MobSpawnInfoBuilder spawns;
        private final ResourceKey<Biome> biome;

        private BiomeHelper(BiomeLoadingEvent event) {
            this.event = event;
            this.generation = event.getGeneration();
            this.spawns = event.getSpawns();
            this.biome = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)event.getName());
        }

        private boolean checkCategory(Biome.BiomeCategory ... categories) {
            for (Biome.BiomeCategory category : categories) {
                if (this.event.getCategory() != category) continue;
                return true;
            }
            return false;
        }

        private boolean checkKey(ResourceKey<?> ... biomes) {
            for (ResourceKey<?> biome : biomes) {
                if (!biome.m_135782_().equals((Object)this.event.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean checkType(BiomeDictionary.Type ... types) {
            for (BiomeDictionary.Type type : types) {
                if (!BiomeDictionary.hasType(this.biome, (BiomeDictionary.Type)type)) continue;
                return true;
            }
            return false;
        }

        private void addFeature(ConfiguredFeature<?, ?> feature, GenerationStep.Decoration stage) {
            this.generation.m_47842_(stage, feature);
        }

        private void addStructure(ConfiguredStructureFeature<?, ?> structure) {
            this.generation.getStructures().add(() -> structure);
        }

        private void addCreatureSpawn(EntityType<?> type, int weight, int min, int max) {
            this.spawns.getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData(type, weight, min, max));
        }
    }
}

