/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Vector3f;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public class ColorableParticleOptions
implements ParticleOptions {
    protected final Vector3f color;
    protected final float scale;

    public ColorableParticleOptions(Vector3f color, float scale) {
        this.color = color;
        this.scale = Mth.m_14036_((float)scale, (float)0.01f, (float)4.0f);
    }

    public static Vector3f readVector3f(StringReader reader) throws CommandSyntaxException {
        reader.expect(' ');
        float f = reader.readFloat();
        reader.expect(' ');
        float f1 = reader.readFloat();
        reader.expect(' ');
        float f2 = reader.readFloat();
        return new Vector3f(f, f1, f2);
    }

    public static Vector3f readVector3f(FriendlyByteBuf buffer) {
        return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.color.m_122239_());
        buffer.writeFloat(this.color.m_122260_());
        buffer.writeFloat(this.color.m_122269_());
        buffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", this.m_6012_().getRegistryName(), Float.valueOf(this.color.m_122239_()), Float.valueOf(this.color.m_122260_()), Float.valueOf(this.color.m_122269_()), Float.valueOf(this.scale));
    }

    public Vector3f getColor() {
        return this.color;
    }

    public float getScale() {
        return this.scale;
    }

    public ParticleType<?> m_6012_() {
        return null;
    }
}

