/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mod.schnappdragon.habitat.core.particles.ColorableParticleOptions;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class NoteParticleOptions
extends ColorableParticleOptions {
    public static final Codec<NoteParticleOptions> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Vector3f.f_176762_.fieldOf("color").forGetter(codec -> codec.color), (App)Codec.FLOAT.fieldOf("scale").forGetter(codec -> Float.valueOf(codec.scale))).apply((Applicative)builder, NoteParticleOptions::new));
    public static final ParticleOptions.Deserializer<NoteParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<NoteParticleOptions>(){

        public NoteParticleOptions fromCommand(ParticleType<NoteParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            Vector3f vector3f = NoteParticleOptions.readVector3f(reader);
            reader.expect(' ');
            float f = reader.readFloat();
            return new NoteParticleOptions(vector3f, f);
        }

        public NoteParticleOptions fromNetwork(ParticleType<NoteParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new NoteParticleOptions(NoteParticleOptions.readVector3f(buffer), buffer.readFloat());
        }
    };

    public NoteParticleOptions(Vector3f color, float scale) {
        super(color, scale);
    }

    @Override
    public ParticleType<?> m_6012_() {
        return (ParticleType)HabitatParticleTypes.NOTE.get();
    }
}

