/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.registry;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import mod.schnappdragon.habitat.common.block.KabloomBushBlock;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.registry.HabitatFeatures;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Features;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.blockplacers.BlockPlacer;
import net.minecraft.world.level.levelgen.feature.blockplacers.SimpleBlockPlacer;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public class HabitatConfiguredFeatures {
    public static final ConfiguredFeature<?, ?> PATCH_RAFFLESIA = (ConfiguredFeature)Feature.f_65763_.m_65815_((FeatureConfiguration)new RandomPatchConfiguration.GrassConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((Block)HabitatBlocks.RAFFLESIA.get()).m_49966_()), (BlockPlacer)SimpleBlockPlacer.f_67529_).m_67996_(6).m_68001_(1).m_68004_(6).m_67991_(2).m_67993_((Set)ImmutableSet.of((Object)Blocks.f_50440_)).m_68003_()).m_7679_(Features.Decorators.f_127091_).m_158241_(4);
    public static final ConfiguredFeature<?, ?> PATCH_KABLOOM_BUSH = (ConfiguredFeature)Feature.f_65763_.m_65815_((FeatureConfiguration)new RandomPatchConfiguration.GrassConfigurationBuilder((BlockStateProvider)new SimpleStateProvider((BlockState)((Block)HabitatBlocks.KABLOOM_BUSH.get()).m_49966_().m_61124_((Property)KabloomBushBlock.AGE, (Comparable)Integer.valueOf(7))), (BlockPlacer)SimpleBlockPlacer.f_67529_).m_67996_(4).m_68001_(1).m_68004_(4).m_67991_(20).m_67993_((Set)ImmutableSet.of((Object)Blocks.f_50440_)).m_68003_()).m_7679_(Features.Decorators.f_127091_).m_158241_(160);
    public static final ConfiguredFeature<?, ?> PATCH_SLIME_FERN = (ConfiguredFeature)((ConfiguredFeature)((Feature)HabitatFeatures.SLIME_FERN_FEATURE.get()).m_65815_((FeatureConfiguration)new RandomPatchConfiguration.GrassConfigurationBuilder((BlockStateProvider)new SimpleStateProvider(((Block)HabitatBlocks.SLIME_FERN.get()).m_49966_()), (BlockPlacer)SimpleBlockPlacer.f_67529_).m_67996_(4).m_68001_(5).m_68004_(4).m_67991_(50).m_68003_()).m_158245_(VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)40))).m_158241_(2);
    public static final ConfiguredFeature<?, ?> PATCH_BALL_CACTUS = (ConfiguredFeature)Feature.f_65763_.m_65815_((FeatureConfiguration)new RandomPatchConfiguration.GrassConfigurationBuilder((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)HabitatBlocks.FLOWERING_ORANGE_BALL_CACTUS.get()).m_49966_(), 3).m_146271_((Object)((Block)HabitatBlocks.FLOWERING_PINK_BALL_CACTUS.get()).m_49966_(), 3).m_146271_((Object)((Block)HabitatBlocks.FLOWERING_RED_BALL_CACTUS.get()).m_49966_(), 2).m_146271_((Object)((Block)HabitatBlocks.FLOWERING_YELLOW_BALL_CACTUS.get()).m_49966_(), 1)), (BlockPlacer)SimpleBlockPlacer.f_67529_).m_67996_(5).m_68001_(1).m_68004_(5).m_67991_(5).m_68003_()).m_7679_(Features.Decorators.f_127091_).m_158241_(16);
    public static final ConfiguredFeature<?, ?> FAIRY_RING = ((Feature)HabitatFeatures.FAIRY_RING_FEATURE.get()).m_65815_((FeatureConfiguration)new NoneFeatureConfiguration());
    public static final ConfiguredFeature<?, ?> HUGE_FAIRY_RING_MUSHROOM = ((Feature)HabitatFeatures.HUGE_FAIRY_RING_MUSHROOM_FEATURE.get()).m_65815_((FeatureConfiguration)new HugeMushroomFeatureConfiguration((BlockStateProvider)new SimpleStateProvider((BlockState)((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_BLOCK.get()).m_49966_().m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleStateProvider((BlockState)((BlockState)((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_STEM.get()).m_49966_().m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HugeMushroomBlock.f_54132_, (Comparable)Boolean.valueOf(false))), 2));

    public static void registerConfiguredFeatures() {
        HabitatConfiguredFeatures.register("rafflesia_patch", PATCH_RAFFLESIA);
        HabitatConfiguredFeatures.register("kabloom_bush_patch", PATCH_KABLOOM_BUSH);
        HabitatConfiguredFeatures.register("slime_fern_patch", PATCH_SLIME_FERN);
        HabitatConfiguredFeatures.register("ball_cactus_patch", PATCH_BALL_CACTUS);
        HabitatConfiguredFeatures.register("fairy_ring", FAIRY_RING);
        HabitatConfiguredFeatures.register("huge_fairy_ring_mushroom", HUGE_FAIRY_RING_MUSHROOM);
    }

    private static void register(String id, ConfiguredFeature<?, ?> configuredFeature) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("habitat", id), configuredFeature);
    }
}

