/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.client.model;

import mod.schnappdragon.habitat.common.entity.animal.Passerine;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PasserineModel<T extends Passerine>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightFoot;
    private final ModelPart leftFoot;
    private final ModelPart tail;
    private float preenAnim;

    public PasserineModel(ModelPart part) {
        this.root = part;
        this.head = part.m_171324_("head");
        this.body = part.m_171324_("body");
        this.tail = this.body.m_171324_("tail");
        this.rightWing = part.m_171324_("right_wing");
        this.leftWing = part.m_171324_("left_wing");
        this.rightFoot = part.m_171324_("right_foot");
        this.leftFoot = part.m_171324_("left_foot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-2.0f));
        head.m_171599_("crest", CubeListBuilder.m_171558_().m_171514_(22, 2).m_171481_(0.0f, -6.0f, -2.0f, 0.0f, 5.0f, 5.0f), PartPose.f_171404_);
        head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -1.0f, -3.0f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-2.0f, -1.5f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)21.5f, (float)0.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(5, 8).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 0.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)2.0f));
        partdefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-1.0f, -1.0f, -1.0f, 1.0f, 3.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)21.0f, (float)-1.0f));
        partdefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(0.0f, -1.0f, -1.0f, 1.0f, 3.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)21.0f, (float)-1.0f));
        partdefinition.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-2.0f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)1.0f));
        partdefinition.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171480_().m_171488_(0.0f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void prepareMobModel(Passerine passerine, float limbSwing, float limbSwingAmount, float partialTick) {
        this.head.f_104201_ = 20.0f;
        this.head.f_104202_ = -2.0f;
        this.body.f_104201_ = 21.5f;
        this.rightWing.f_104201_ = 21.0f;
        this.leftWing.f_104201_ = 21.0f;
        this.rightFoot.f_104201_ = 23.0f;
        this.leftFoot.f_104201_ = 23.0f;
        this.body.f_104203_ = 0.0f;
        this.rightWing.f_104203_ = 0.0f;
        this.leftWing.f_104203_ = 0.0f;
        this.rightWing.f_104205_ = 0.0f;
        this.leftWing.f_104205_ = 0.0f;
        this.rightFoot.f_104203_ = 0.0f;
        this.leftFoot.f_104203_ = 0.0f;
        switch (PasserineModel.getState(passerine)) {
            case SLEEPING: {
                this.head.f_104201_ = 21.0f;
                this.head.f_104202_ = -1.5f;
                this.body.f_104201_ = 22.5f;
                this.rightWing.f_104201_ = 22.0f;
                this.leftWing.f_104201_ = 22.0f;
                this.head.f_104203_ = 0.3491f;
                this.head.f_104204_ = 2.094f;
                this.tail.f_104203_ = 0.1745f;
                break;
            }
            case FLYING: {
                this.body.f_104203_ = -0.3927f;
                this.rightWing.f_104203_ = -0.5236f;
                this.leftWing.f_104203_ = -0.5236f;
                this.rightFoot.f_104203_ = -0.5236f;
                this.leftFoot.f_104203_ = -0.5236f;
                this.rightFoot.f_104204_ = 0.1571f;
                this.leftFoot.f_104204_ = -0.1571f;
                this.tail.f_104203_ = 0.1309f;
                break;
            }
            case PREENING: {
                this.preenAnim = (float)passerine.getRemainingPreeningTicks() - partialTick;
            }
            default: {
                this.body.f_104203_ = -0.0873f;
                this.rightWing.f_104203_ = -0.1963f;
                this.leftWing.f_104203_ = -0.1963f;
                this.rightFoot.f_104204_ = 0.1745f;
                this.leftFoot.f_104204_ = -0.1745f;
                this.tail.f_104203_ = 0.3927f;
            }
        }
    }

    public void setupAnim(Passerine passerine, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (PasserineModel.getState(passerine) == State.PREENING) {
            int remainingPreeningTicks = passerine.getRemainingPreeningTicks();
            if (remainingPreeningTicks >= 4 && remainingPreeningTicks <= 36) {
                float f = (this.preenAnim - 4.0f) / 32.0f;
                this.head.f_104202_ = -1.0f;
                this.head.f_104203_ = 0.1745f + 0.1745f * Mth.m_14031_((float)(f * 57.3f));
                this.head.f_104204_ = 1.833f + 0.2793f * Mth.m_14031_((float)(f * 38.2f));
                this.rightWing.f_104203_ = -0.5236f;
                this.rightWing.f_104205_ = 1.396f;
            } else {
                float f = (remainingPreeningTicks < 4 ? this.preenAnim : 40.0f - this.preenAnim) / 4.0f;
                this.head.f_104202_ = Mth.m_14179_((float)f, (float)-2.0f, (float)-1.0f);
                this.head.f_104203_ = Mth.m_14179_((float)f, (float)0.0f, (float)0.1745f);
                this.head.f_104204_ = Mth.m_14179_((float)f, (float)0.0f, (float)1.833f);
                this.rightWing.f_104203_ = Mth.m_14179_((float)f, (float)-0.1963f, (float)-0.5236f);
                this.rightWing.f_104205_ = Mth.m_14179_((float)f, (float)0.0f, (float)1.396f);
            }
        } else if (PasserineModel.getState(passerine) != State.SLEEPING) {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            if (PasserineModel.getState(passerine) == State.FLYING) {
                float f = ageInTicks * 0.2f;
                this.head.f_104201_ = 20.0f + f;
                this.body.f_104201_ = 21.5f + f;
                this.rightWing.f_104201_ = 21.0f + f;
                this.leftWing.f_104201_ = 21.0f + f;
                this.rightFoot.f_104201_ = 23.0f + f;
                this.leftFoot.f_104201_ = 23.0f + f;
                this.tail.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.35f * limbSwingAmount;
                this.rightWing.f_104205_ = 0.2618f + ageInTicks;
                this.leftWing.f_104205_ = -0.2618f - ageInTicks;
            } else {
                this.rightFoot.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                this.leftFoot.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            }
        }
    }

    private static State getState(Passerine passerine) {
        if (passerine.isPreening()) {
            return State.PREENING;
        }
        if (passerine.isAsleep()) {
            return State.SLEEPING;
        }
        return passerine.m_142592_() ? State.FLYING : State.STANDING;
    }

    public static enum State {
        FLYING,
        STANDING,
        SLEEPING,
        PREENING;

    }
}

