/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.client.renderer.entity;

import mod.schnappdragon.habitat.client.model.PasserineModel;
import mod.schnappdragon.habitat.client.renderer.HabitatModelLayers;
import mod.schnappdragon.habitat.client.renderer.entity.layers.PasserineEyesLayer;
import mod.schnappdragon.habitat.common.entity.animal.Passerine;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PasserineRenderer
extends MobRenderer<Passerine, PasserineModel<Passerine>> {
    public static final ResourceLocation[] PASSERINE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("habitat", "textures/entity/passerine/american_goldfinch.png"), new ResourceLocation("habitat", "textures/entity/passerine/bali_myna.png"), new ResourceLocation("habitat", "textures/entity/passerine/blue_jay.png"), new ResourceLocation("habitat", "textures/entity/passerine/common_sparrow.png"), new ResourceLocation("habitat", "textures/entity/passerine/eastern_bluebird.png"), new ResourceLocation("habitat", "textures/entity/passerine/eurasian_bullfinch.png"), new ResourceLocation("habitat", "textures/entity/passerine/flame_robin.png"), new ResourceLocation("habitat", "textures/entity/passerine/northern_cardinal.png"), new ResourceLocation("habitat", "textures/entity/passerine/red_throated_parrotfinch.png"), new ResourceLocation("habitat", "textures/entity/passerine/violet_backed_starling.png")};
    public static final ResourceLocation PASSERINE_BERDLY_LOCATION = new ResourceLocation("habitat", "textures/entity/passerine/berdly.png");
    public static final ResourceLocation PASSERINE_GOLDFISH_LOCATION = new ResourceLocation("habitat", "textures/entity/passerine/goldfish.png");
    public static final ResourceLocation PASSERINE_TURKEY_LOCATION = new ResourceLocation("habitat", "textures/entity/passerine/turkey.png");

    public PasserineRenderer(EntityRendererProvider.Context context) {
        super(context, new PasserineModel(context.m_174023_(HabitatModelLayers.PASSERINE)), 0.25f);
        this.m_115326_(new PasserineEyesLayer(this));
    }

    public ResourceLocation getTextureLocation(Passerine passerine) {
        if (passerine.isBerdly()) {
            return PASSERINE_BERDLY_LOCATION;
        }
        if (passerine.isGoldfish()) {
            return PASSERINE_GOLDFISH_LOCATION;
        }
        if (passerine.isTurkey()) {
            return PASSERINE_TURKEY_LOCATION;
        }
        return PASSERINE_LOCATIONS[passerine.getVariant()];
    }

    public float getBob(Passerine passerine, float partialTicks) {
        float f = Mth.m_14179_((float)partialTicks, (float)passerine.initialFlap, (float)passerine.flap);
        float f1 = Mth.m_14179_((float)partialTicks, (float)passerine.initialFlapSpeed, (float)passerine.flapSpeed);
        return (Mth.m_14031_((float)f) + 1.0f) * f1;
    }
}

