/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import mod.schnappdragon.habitat.common.block.AbstractBallCactusBlock;
import mod.schnappdragon.habitat.common.block.BallCactusColor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class GrowingBallCactusBlock
extends AbstractBallCactusBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    protected static final AABB TOUCH_AABB = new AABB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);

    public GrowingBallCactusBlock(BallCactusColor colorIn, BlockBehaviour.Properties properties) {
        super(colorIn, properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getColor().getFlower());
    }

    @Override
    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.m_6095_() != EntityType.f_20550_ && worldIn.m_45933_(null, TOUCH_AABB.m_82338_(pos)).contains(entityIn)) {
            entityIn.m_6469_(DamageSource.f_19314_, 1.0f);
        }
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0)) {
            worldIn.m_46597_(pos, this.getColor().getBallCactus().m_49966_());
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.m_46597_(pos, (rand.nextBoolean() ? this.getColor().getBallCactus() : this.getColor().getFloweringBallCactus()).m_49966_());
    }
}

