/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.entity.projectile.ThrownKabloomFruit;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolActions;

public class KabloomBushBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;

    public KabloomBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)AGE)];
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if ((Integer)state.m_61143_((Property)AGE) == 7 && entityIn.m_6095_() != EntityType.f_20550_) {
            this.dropFruit(state, worldIn, pos, true, false);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if ((Integer)state.m_61143_((Property)AGE) == 7) {
            if (player.m_21120_(handIn).canPerformAction(ToolActions.SHEARS_HARVEST)) {
                KabloomBushBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)HabitatItems.KABLOOM_FRUIT.get(), 1));
                player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
                worldIn.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)), 2);
                worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.KABLOOM_BUSH_SHEAR.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.nextFloat() * 0.4f);
            } else {
                this.dropFruit(state, worldIn, pos, true, false);
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void onCaughtFire(BlockState state, Level worldIn, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if ((Integer)state.m_61143_((Property)AGE) == 7) {
            this.dropFruit(state, worldIn, pos, true, true);
        }
    }

    public void m_8101_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack) {
        super.m_8101_(state, worldIn, pos, stack);
        if ((Integer)state.m_61143_((Property)AGE) == 7 && !stack.canPerformAction(ToolActions.SHEARS_DISARM) && worldIn.m_46469_().m_46207_(GameRules.f_46136_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 0) {
            this.dropFruit(state, (Level)worldIn, pos, false, false);
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    private void dropFruit(BlockState state, Level worldIn, BlockPos pos, boolean replaceBush, boolean setFire) {
        if (!worldIn.f_46443_) {
            if (replaceBush) {
                worldIn.m_151555_(GameEvent.f_157792_, pos);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)), 2);
                worldIn.m_5594_(null, pos, (SoundEvent)HabitatSoundEvents.KABLOOM_BUSH_RUSTLE.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.nextFloat() * 0.4f);
            }
            ThrownKabloomFruit kabloom = new ThrownKabloomFruit(worldIn, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.6f, (float)pos.m_123343_() + 0.5f);
            if (setFire) {
                kabloom.m_20254_(8);
            }
            worldIn.m_7967_((Entity)kabloom);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 7;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if ((Integer)state.m_61143_((Property)AGE) < 7 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 7;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(7, (Integer)state.m_61143_((Property)AGE) + Mth.m_14072_((Random)rand, (int)2, (int)4)))), 2);
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return (Integer)state.m_61143_((Property)AGE) > 1 ? BlockPathTypes.DANGER_OTHER : null;
    }
}

