/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.event;

import mod.schnappdragon.habitat.common.entity.ai.goal.RabbitAvoidEntityGoal;
import mod.schnappdragon.habitat.common.entity.monster.Pooka;
import mod.schnappdragon.habitat.core.registry.HabitatEffects;
import mod.schnappdragon.habitat.core.tags.HabitatEntityTypeTags;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="habitat")
public class HabitatEvents {
    @SubscribeEvent
    public static void addGoals(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_() == EntityType.f_20517_ && HabitatEntityTypeTags.POOKA_ATTACK_TARGETS.m_8110_((Object)EntityType.f_20517_)) {
            Rabbit rabbit = (Rabbit)entity;
            rabbit.f_21345_.m_25352_(4, new RabbitAvoidEntityGoal<Pooka>(rabbit, Pooka.class, 2.25f, 2.2, 2.2));
        }
    }

    @SubscribeEvent
    public static void reduceExplosionDamage(LivingDamageEvent event) {
        if (event.getEntityLiving().m_21023_((MobEffect)HabitatEffects.BLAST_ENDURANCE.get()) && event.getSource().m_19372_()) {
            LivingEntity livingEntity = event.getEntityLiving();
            DamageSource source = event.getSource();
            int lvl = Math.min(livingEntity.m_21124_((MobEffect)HabitatEffects.BLAST_ENDURANCE.get()).m_19564_(), 11);
            float dmg = Mth.m_14143_((float)(event.getAmount() * (0.88f - 0.08f * (float)lvl)));
            int res = (int)(event.getAmount() - dmg);
            event.setAmount(dmg);
            if (livingEntity instanceof ServerPlayer) {
                ((ServerPlayer)livingEntity).m_36222_(Stats.f_12934_, res * 10);
            } else if (source.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)source.m_7639_()).m_36222_(Stats.f_12930_, res * 10);
            }
        }
    }

    @SubscribeEvent
    public static void causePricklingDamage(LivingHurtEvent event) {
        if (event.getEntityLiving().m_21023_((MobEffect)HabitatEffects.PRICKLING.get())) {
            LivingEntity livingEntity = event.getEntityLiving();
            DamageSource source = event.getSource();
            int lvl = livingEntity.m_21124_((MobEffect)HabitatEffects.PRICKLING.get()).m_19564_();
            if (livingEntity.m_21187_().nextInt(4) < 2 + lvl && !source.m_19387_() && !source.m_19372_() && source.m_7640_() instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)source.m_7640_();
                attacker.m_6469_(DamageSource.m_19335_((Entity)livingEntity), 1.0f + (float)(lvl > 0 ? livingEntity.m_21187_().nextInt(lvl) : 0));
            }
        }
    }
}

