/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.event.world;

import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import mod.schnappdragon.habitat.core.registry.HabitatPlacedFeatures;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="habitat")
public class HabitatBiomeLoadingEvent {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void modifyBiomes(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            BiomeHelper biome = new BiomeHelper(event);
            if (biome.check(Biomes.f_186755_)) {
                biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 12, 4, 4);
            }
            if (biome.check(BiomeDictionary.Type.OVERWORLD)) {
                biome.addFeature(HabitatPlacedFeatures.PATCH_SLIME_FERN, GenerationStep.Decoration.UNDERGROUND_DECORATION);
                if (biome.check(Biomes.f_48203_, Biomes.f_48159_, Biomes.f_48194_)) {
                    biome.addFeature(HabitatPlacedFeatures.PATCH_BALL_CACTUS, GenerationStep.Decoration.VEGETAL_DECORATION);
                }
                if (biome.check(Biome.BiomeCategory.FOREST)) {
                    if (biome.check(Biomes.f_48179_)) {
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 24, 4, 4);
                    } else if (!biome.check(BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD)) {
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 12, 4, 4);
                    }
                }
                if (biome.check(Biome.BiomeCategory.JUNGLE)) {
                    if (biome.check(Biomes.f_48222_)) {
                        biome.addFeature(HabitatPlacedFeatures.PATCH_RAFFLESIA, GenerationStep.Decoration.VEGETAL_DECORATION);
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 24, 4, 4);
                    } else if (biome.check(Biomes.f_48197_)) {
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 24, 4, 4);
                    } else if (biome.check(Biomes.f_186769_)) {
                        biome.addFeature(HabitatPlacedFeatures.PATCH_RAFFLESIA_SPARSE, GenerationStep.Decoration.VEGETAL_DECORATION);
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 12, 4, 4);
                    } else {
                        biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 12, 4, 4);
                    }
                }
                if (biome.check(Biome.BiomeCategory.PLAINS)) {
                    biome.addFeature(HabitatPlacedFeatures.PATCH_KABLOOM_BUSH, GenerationStep.Decoration.VEGETAL_DECORATION);
                }
                if (biome.check(Biome.BiomeCategory.SAVANNA)) {
                    biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 4, 4, 4);
                }
                if (biome.check(Biome.BiomeCategory.TAIGA)) {
                    biome.addCreatureSpawn((EntityType)HabitatEntityTypes.PASSERINE.get(), 12, 4, 4);
                }
            }
        }
    }

    private static class BiomeHelper {
        private final BiomeLoadingEvent event;
        private final BiomeGenerationSettingsBuilder generation;
        private final MobSpawnSettingsBuilder spawns;
        private final ResourceKey<Biome> biome;

        private BiomeHelper(BiomeLoadingEvent event) {
            this.event = event;
            this.generation = event.getGeneration();
            this.spawns = event.getSpawns();
            this.biome = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)event.getName());
        }

        private boolean check(Biome.BiomeCategory ... categories) {
            for (Biome.BiomeCategory category : categories) {
                if (this.event.getCategory() != category) continue;
                return true;
            }
            return false;
        }

        private boolean check(ResourceKey<?> ... biomes) {
            for (ResourceKey<?> biome : biomes) {
                if (!biome.m_135782_().equals((Object)this.event.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean check(BiomeDictionary.Type ... types) {
            for (BiomeDictionary.Type type : types) {
                if (!BiomeDictionary.hasType(this.biome, (BiomeDictionary.Type)type)) continue;
                return true;
            }
            return false;
        }

        private void addFeature(PlacedFeature feature, GenerationStep.Decoration stage) {
            this.generation.m_186664_(stage, feature);
        }

        private void addCreatureSpawn(EntityType<?> type, int weight, int min, int max) {
            this.spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(type, weight, min, max));
        }
    }
}

