/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.api.conditions;

import com.google.gson.JsonObject;
import mod.schnappdragon.habitat.core.util.CompatHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public final class QuarkFlagRecipeCondition
implements ICondition {
    private final ResourceLocation location;
    private final String flag;

    public QuarkFlagRecipeCondition(ResourceLocation location, String flag) {
        this.location = location;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test(ICondition.IContext context) {
        return CompatHelper.checkQuarkFlag(this.flag);
    }

    public boolean test() {
        return this.test(ICondition.IContext.EMPTY);
    }

    public static class Serializer
    implements IConditionSerializer<QuarkFlagRecipeCondition> {
        private final ResourceLocation location = new ResourceLocation("habitat", "quark_flag");

        public void write(JsonObject json, QuarkFlagRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public QuarkFlagRecipeCondition read(JsonObject json) {
            return new QuarkFlagRecipeCondition(this.location, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

