/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armorEffects;

import immersive_armors.item.ExtendedArmorItem;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public abstract class ArmorEffect {
    private final List<EquipmentSlotType> armorEquipmentSlots = Arrays.asList(EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET);

    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        return amount;
    }

    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        return amount;
    }

    protected Stream<ItemStack> getMatchingEquippedArmor(LivingEntity entity, ExtendedArmorMaterial material) {
        return this.armorEquipmentSlots.stream().map(arg_0 -> ((LivingEntity)entity).func_184582_a(arg_0)).filter(Objects::nonNull).filter(stack -> stack.func_77973_b() instanceof ExtendedArmorItem && ((ExtendedArmorItem)stack.func_77973_b()).getMaterial() == material);
    }

    protected Stream<ItemStack> getMatchingEquippedArmor(LivingEntity entity, ItemStack stack) {
        return this.getMatchingEquippedArmor(entity, ((ExtendedArmorItem)stack.func_77973_b()).getMaterial());
    }

    protected boolean isPrimaryArmor(ItemStack stack, LivingEntity entity) {
        return stack == this.getMatchingEquippedArmor(entity, stack).findFirst().orElse(null);
    }

    protected int getSetCount(ItemStack stack, LivingEntity entity) {
        return (int)this.getMatchingEquippedArmor(entity, stack).count();
    }

    protected int getSetCount(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("set_bonus");
    }

    public void appendTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
    }

    public void equippedTick(ItemStack stack, World world, LivingEntity entity, int slot) {
        if (world.func_82737_E() % 20L == 0L) {
            stack.func_196082_o().func_74768_a("set_bonus", this.getSetCount(stack, entity));
        }
    }
}

