/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armorEffects;

import immersive_armors.armorEffects.ArmorEffect;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class DivineArmorEffect
extends ArmorEffect {
    private final long cooldown;

    public DivineArmorEffect(long cooldown) {
        this.cooldown = cooldown;
    }

    private boolean isCharged(long time, ItemStack armor) {
        CompoundNBT tag = armor.func_196082_o();
        return (!tag.func_74764_b("last_divine") || tag.func_74763_f("last_divine") + this.cooldown < time) && this.getSetCount(armor) == 4;
    }

    @Override
    public void appendTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.appendTooltip(stack, world, tooltip, context);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.immersive_armors.divine.description").func_240699_a_(TextFormatting.GRAY));
        int count = this.getSetCount(stack);
        if (count == 4) {
            if (world != null && this.isCharged(world.func_82737_E(), stack)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("armorEffect.charged").func_240699_a_(TextFormatting.AQUA));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("immersive_armors.incomplete", new Object[]{count, 4}));
        }
    }

    @Override
    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        if (this.isPrimaryArmor(armor, entity)) {
            long time = entity.field_70170_p.func_82737_E();
            boolean charged = this.getMatchingEquippedArmor(entity, armor).anyMatch(a -> this.isCharged(time, (ItemStack)a));
            if (charged) {
                entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187689_f, entity.func_184176_by(), 0.5f, 1.25f);
                this.getMatchingEquippedArmor(entity, armor).forEach(a -> a.func_196082_o().func_74772_a("last_divine", time));
                return 0.0f;
            }
        }
        return amount;
    }
}

