/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armorEffects;

import immersive_armors.armorEffects.ArmorEffect;
import immersive_armors.util.FlowingText;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class SteamTechArmorEffect
extends ArmorEffect {
    @Override
    public void appendTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag context) {
        super.appendTooltip(stack, world, tooltip, context);
        IFormattableTextComponent text = new TranslationTextComponent("armorEffect.steamTech." + this.getEquipmentSlot(stack).name().toLowerCase(Locale.ROOT)).func_240699_a_(TextFormatting.GRAY);
        tooltip.addAll(FlowingText.wrap((ITextComponent)text, 140));
    }

    @Override
    public void equippedTick(ItemStack armor, World world, LivingEntity entity, int slot) {
        super.equippedTick(armor, world, entity, slot);
        if (this.getEquipmentSlot(armor) == EquipmentSlotType.FEET) {
            Vector3d velocity;
            if (entity.func_70681_au().nextInt(10) == 0) {
                double x = Math.cos((double)(entity.field_70761_aq / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                double z = Math.sin((double)(entity.field_70761_aq / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, entity.func_226277_ct_() + x, entity.func_226278_cu_() + (double)1.2f, entity.func_226281_cx_() + z, x * (double)0.2f, (double)-0.025f, z * (double)0.2f);
            }
            if ((velocity = entity.func_213322_ci()).func_82617_b() < -0.75) {
                entity.func_213293_j(velocity.field_72450_a, -0.75, velocity.field_72449_c);
                entity.field_70143_R = 0.0f;
                world.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, entity.func_226282_d_(0.5), entity.func_226278_cu_(), entity.func_226287_g_(0.5), 0.0, -0.5, 0.0);
                if (entity.field_70173_aa % 4 == 0) {
                    entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187745_eA, entity.func_184176_by(), 0.1f, 1.0f);
                }
            }
        }
        if (!world.func_201670_d() && entity.func_225608_bj_() && this.getEquipmentSlot(armor) == EquipmentSlotType.HEAD && entity.field_70173_aa % 20 == 0) {
            boolean[] sound = new boolean[]{false};
            world.func_72839_b((Entity)entity, new AxisAlignedBB(entity.func_213303_ch(), entity.func_213303_ch()).func_186662_g(16.0)).forEach(e -> {
                if (e instanceof MonsterEntity) {
                    LivingEntity le = (LivingEntity)e;
                    le.func_195064_c(new EffectInstance(Effects.field_188423_x, 5));
                    if (!sound[0]) {
                        sound[0] = true;
                        entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187839_fV, entity.func_184176_by(), 0.25f, 3.0f);
                    }
                }
            });
        }
    }

    @Override
    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        LivingEntity attacker;
        ItemStack hand;
        if (this.getEquipmentSlot(armor) == EquipmentSlotType.CHEST && source.func_76346_g() instanceof LivingEntity && (hand = (attacker = (LivingEntity)source.func_76346_g()).func_184586_b(attacker.func_184600_cs())).func_190926_b()) {
            amount *= 4.0f;
        }
        if (!source.func_76352_a() && this.getEquipmentSlot(armor) == EquipmentSlotType.LEGS) {
            amount *= 1.1f;
        }
        return amount;
    }

    private EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return ((ArmorItem)stack.func_77973_b()).func_185083_B_();
    }
}

