/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import immersive_armors.client.render.entity.model.CapeModel;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class CapePiece<M extends CapeModel<LivingEntity>>
extends Piece {
    private final M model;

    public CapePiece(M model) {
        this.model = model;
    }

    private ResourceLocation getCapeTexture(ExtendedArmorItem item, boolean overlay) {
        return new ResourceLocation("immersive_armors", "textures/models/armor/" + item.getMaterial().func_200897_d() + "/cape" + (overlay ? "_overlay" : "") + ".png");
    }

    private Vector3d predictPosition(Entity entity, float tickDelta) {
        return new Vector3d(MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70169_q, (double)entity.func_226277_ct_()), MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70167_r, (double)entity.func_226278_cu_()), MathHelper.func_219803_d((double)tickDelta, (double)entity.field_70166_s, (double)entity.func_226281_cx_()));
    }

    @Override
    public void render(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, LivingEntity entity, ItemStack itemStack, float tickDelta, EquipmentSlotType armorSlot, BipedModel<LivingEntity> contextModel) {
        if (itemStack.func_77973_b() instanceof ExtendedArmorItem) {
            IVertexBuilder vertexConsumer;
            ExtendedArmorItem armor = (ExtendedArmorItem)itemStack.func_77973_b();
            CapeAngles angles = new CapeAngles(itemStack);
            angles.updateCapeAngles((Entity)entity, tickDelta);
            angles.store(itemStack);
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 0.125);
            float n = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar);
            double o = MathHelper.func_76126_a((float)(n * ((float)Math.PI / 180)));
            double p = -MathHelper.func_76134_b((float)(n * ((float)Math.PI / 180)));
            double q = angles.deltaY * 40.0;
            q = MathHelper.func_151237_a((double)q, (double)-6.0, (double)32.0);
            double r = (angles.deltaX * o + angles.deltaZ * p) * 100.0;
            r = MathHelper.func_151237_a((double)r, (double)0.0, (double)150.0);
            double s = (angles.deltaX * p - angles.deltaZ * o) * 100.0;
            s = MathHelper.func_151237_a((double)s, (double)-20.0, (double)20.0);
            if (r < 0.0) {
                r = 0.0;
            }
            if (entity.func_213453_ef()) {
                q += 22.5;
                matrices.func_227861_a_(0.0, 0.25, 0.0);
            }
            matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(6.0 + r / 2.0 + q)));
            matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(s / 2.0)));
            matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(180.0 - s / 2.0)));
            ((CapeModel)((Object)this.model)).setAngles((LivingEntity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (this.isColored()) {
                int i = ((IDyeableArmorItem)armor).func_200886_f(itemStack);
                float red = (float)(i >> 16 & 0xFF) / 255.0f;
                float green = (float)(i >> 8 & 0xFF) / 255.0f;
                float blue = (float)(i & 0xFF) / 255.0f;
                vertexConsumer = vertexConsumers.getBuffer(RenderType.func_239263_a_((ResourceLocation)this.getCapeTexture(armor, false)));
                ((CapeModel)((Object)this.model)).func_225598_a_(matrices, vertexConsumer, light, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
                vertexConsumer = vertexConsumers.getBuffer(RenderType.func_239263_a_((ResourceLocation)this.getCapeTexture(armor, true)));
            } else {
                vertexConsumer = vertexConsumers.getBuffer(RenderType.func_239263_a_((ResourceLocation)this.getCapeTexture(armor, false)));
            }
            ((CapeModel)((Object)this.model)).func_225598_a_(matrices, vertexConsumer, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.func_227865_b_();
        }
    }

    private class CapeAngles {
        private double capeX;
        private double capeY;
        private double capeZ;
        private double deltaX;
        private double deltaY;
        private double deltaZ;
        private float lastTickDelta;

        private void updateCapeAngles(Entity entity, float tickDelta) {
            float delta;
            Vector3d pos = CapePiece.this.predictPosition(entity, tickDelta);
            double deltaX = pos.func_82615_a() - this.capeX;
            double deltaY = pos.func_82617_b() - this.capeY;
            double deltaZ = pos.func_82616_c() - this.capeZ;
            if (deltaX > 10.0 || deltaX < -10.0) {
                this.capeX = pos.func_82615_a();
                deltaX = 0.0;
            }
            if (deltaY > 10.0 || deltaY < -10.0) {
                this.capeY = pos.func_82617_b();
                deltaY = 0.0;
            }
            if (deltaZ > 10.0 || deltaZ < -10.0) {
                this.capeZ = pos.func_82616_c();
                deltaZ = 0.0;
            }
            if ((double)(delta = tickDelta - this.lastTickDelta) < 0.0) {
                delta = 1.0f + delta;
            }
            this.lastTickDelta = tickDelta;
            this.capeX += deltaX * (double)(delta *= 0.25f);
            this.capeZ += deltaZ * (double)delta;
            this.capeY += deltaY * (double)delta;
            this.deltaX = this.capeX - pos.func_82615_a();
            this.deltaY = this.capeY - pos.func_82617_b();
            this.deltaZ = this.capeZ - pos.func_82616_c();
        }

        public CapeAngles(ItemStack cape) {
            CompoundNBT tag = cape.func_196082_o();
            if (tag.func_74764_b("capeAngles")) {
                CompoundNBT angles = tag.func_74775_l("capeAngles");
                this.capeX = angles.func_74769_h("capeX");
                this.capeY = angles.func_74769_h("capeY");
                this.capeZ = angles.func_74769_h("capeZ");
                this.lastTickDelta = angles.func_74760_g("lastTickDelta");
            }
        }

        public void store(ItemStack cape) {
            CompoundNBT tag = cape.func_196082_o();
            CompoundNBT angles = new CompoundNBT();
            angles.func_74780_a("capeX", this.capeX);
            angles.func_74780_a("capeY", this.capeY);
            angles.func_74780_a("capeZ", this.capeZ);
            angles.func_74776_a("lastTickDelta", this.lastTickDelta);
            tag.func_218657_a("capeAngles", (INBT)angles);
        }
    }
}

