/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.cobalt.registration;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestType;
import org.jetbrains.annotations.Nullable;

public class Registration {
    private static Impl INSTANCE;

    public static <T> T register(Registry<? super T> registry, ResourceLocation id, T obj) {
        return INSTANCE.register(registry, id, obj);
    }

    public static abstract class Impl {
        protected Impl() {
            INSTANCE = this;
        }

        public abstract <T> T register(Registry<? super T> var1, ResourceLocation var2, T var3);

        public abstract ItemGroup itemGroup(ResourceLocation var1, Supplier<ItemStack> var2);

        public abstract Supplier<BasicParticleType> simpleParticle();

        public abstract Function<ResourceLocation, ITag<Block>> blockTag();

        public abstract Function<ResourceLocation, ITag<Item>> itemTag();

        public abstract Function<ResourceLocation, Activity> activity();

        public abstract <T extends Sensor<?>> BiFunction<ResourceLocation, Supplier<T>, SensorType<T>> sensor();

        public abstract <U> BiFunction<ResourceLocation, Optional<Codec<U>>, MemoryModuleType<U>> memoryModule();

        public abstract <T extends LivingEntity> BiFunction<EntityType<T>, Supplier<AttributeModifierMap.MutableAttribute>, EntityType<T>> defaultEntityAttributes();

        public abstract PoiFactory<PointOfInterestType> poi();

        public abstract ProfessionFactory<VillagerProfession> profession();
    }

    public static interface ProfessionFactory<T> {
        public T apply(ResourceLocation var1, PointOfInterestType var2, @Nullable SoundEvent var3, Iterable<Item> var4, Iterable<Block> var5);
    }

    protected static interface PoiFactory<T> {
        public T apply(ResourceLocation var1, int var2, int var3, Block ... var4);
    }

    public static class ObjectBuilders {

        public static class Profession {
            public static ProfessionFactory<VillagerProfession> creator() {
                return INSTANCE.profession();
            }
        }

        public static class Poi {
            public static PointOfInterestType create(ResourceLocation id, int ticketCount, int searchDistance, Block ... blocks) {
                return INSTANCE.poi().apply(id, ticketCount, searchDistance, blocks);
            }
        }

        public static class MemoryModules {
            public static <U> MemoryModuleType<U> create(ResourceLocation id, Optional<Codec<U>> codec) {
                return INSTANCE.memoryModule().apply(id, codec);
            }
        }

        public static class Sensors {
            public static <T extends Sensor<?>> SensorType<T> create(ResourceLocation id, Supplier<T> factory) {
                return INSTANCE.sensor().apply(id, factory);
            }
        }

        public static class Activities {
            public static Activity create(ResourceLocation id) {
                return INSTANCE.activity().apply(id);
            }
        }

        public static class Tags {
            public static ITag<Block> block(ResourceLocation id) {
                return INSTANCE.blockTag().apply(id);
            }

            public static ITag<Item> item(ResourceLocation id) {
                return INSTANCE.itemTag().apply(id);
            }
        }

        public static class Particles {
            public static BasicParticleType simpleParticle() {
                return INSTANCE.simpleParticle().get();
            }
        }

        public static class DefaultEntityAttributes {
            public static <T extends LivingEntity> EntityType<T> add(EntityType<T> type, Supplier<AttributeModifierMap.MutableAttribute> attributes) {
                return INSTANCE.defaultEntityAttributes().apply(type, attributes);
            }
        }

        public static class ItemGroups {
            public static ItemGroup create(ResourceLocation id, Supplier<ItemStack> icon) {
                return INSTANCE.itemGroup(id, icon);
            }
        }
    }
}

