/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import immersive_armors.armorEffects.ArmorEffect;
import immersive_armors.client.render.entity.piece.Piece;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundEvent;

public class ExtendedArmorMaterial
implements IArmorMaterial {
    private final String name;
    private int durabilityMultiplier;
    private int[] protectionAmount;
    private final boolean[] hidesSecondLayer = new boolean[]{false, false, false, false};
    private float toughness;
    private float knockbackResistance;
    private int enchantability;
    private float weight;
    private int extraHealth;
    private int color = 10511680;
    private float attackDamage;
    private float attackSpeed;
    private int luck;
    private final List<ArmorEffect> effects = new LinkedList<ArmorEffect>();
    private final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private final Map<EquipmentSlotType, List<Piece>> pieces = new HashMap<EquipmentSlotType, List<Piece>>();
    private boolean hideCape;
    private SoundEvent equipSound;
    private Supplier<Ingredient> repairIngredient;
    private static final int[] BASE_DURABILITY = new int[]{13, 15, 16, 11};

    public ExtendedArmorMaterial(String name) {
        this.pieces.put(EquipmentSlotType.HEAD, new LinkedList());
        this.pieces.put(EquipmentSlotType.CHEST, new LinkedList());
        this.pieces.put(EquipmentSlotType.LEGS, new LinkedList());
        this.pieces.put(EquipmentSlotType.FEET, new LinkedList());
        this.name = name;
        this.protectionAmount(0, 0, 0, 0);
    }

    public ExtendedArmorMaterial durabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
        return this;
    }

    public ExtendedArmorMaterial protectionAmount(int helmet, int chestplate, int legging, int boots) {
        this.protectionAmount = new int[]{boots, legging, chestplate, helmet};
        return this;
    }

    public ExtendedArmorMaterial toughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public ExtendedArmorMaterial enchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ExtendedArmorMaterial equipSound(SoundEvent equipSound) {
        this.equipSound = equipSound;
        return this;
    }

    public ExtendedArmorMaterial repairIngredient(Supplier<Ingredient> repairIngredient) {
        this.repairIngredient = repairIngredient;
        return this;
    }

    public ExtendedArmorMaterial knockbackReduction(float knockbackReduction) {
        this.knockbackResistance = knockbackReduction;
        return this;
    }

    public ExtendedArmorMaterial weight(float weight) {
        this.weight = weight;
        return this;
    }

    public ExtendedArmorMaterial extraHealth(int extraHealth) {
        this.extraHealth = extraHealth;
        return this;
    }

    public ExtendedArmorMaterial color(int color) {
        this.color = color;
        return this;
    }

    public ExtendedArmorMaterial attackDamage(int attackDamage) {
        this.attackDamage = attackDamage;
        return this;
    }

    public ExtendedArmorMaterial attackSpeed(int attackSpeed) {
        this.attackSpeed = attackSpeed;
        return this;
    }

    public ExtendedArmorMaterial luck(int luck) {
        this.luck = luck;
        return this;
    }

    public ExtendedArmorMaterial effect(ArmorEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ExtendedArmorMaterial enchantment(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public ExtendedArmorMaterial hideCape() {
        this.hideCape = true;
        return this;
    }

    public ExtendedArmorMaterial head(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlotType.HEAD).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial chest(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlotType.CHEST).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial legs(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlotType.LEGS).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial feet(Piece pieceSupplier) {
        this.pieces.get(EquipmentSlotType.FEET).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial upper(Piece pieceSupplier) {
        this.head(pieceSupplier);
        this.chest(pieceSupplier);
        this.feet(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial lower(Piece pieceSupplier) {
        this.legs(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial full(Piece pieceSupplier) {
        this.upper(pieceSupplier);
        this.lower(pieceSupplier);
        return this;
    }

    public String func_200897_d() {
        return this.name;
    }

    public int func_200896_a(EquipmentSlotType slot) {
        return BASE_DURABILITY[slot.func_188454_b()] * this.durabilityMultiplier;
    }

    public int func_200902_b(EquipmentSlotType slot) {
        return this.protectionAmount[slot.func_188454_b()];
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.equipSound;
    }

    public Ingredient func_200898_c() {
        return this.repairIngredient.get();
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getExtraHealth() {
        return this.extraHealth;
    }

    public int getColor() {
        return this.color;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public int getLuck() {
        return this.luck;
    }

    public List<ArmorEffect> getEffects() {
        return this.effects;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public boolean hasEnchantment(Enchantment enchantment) {
        return this.enchantments.containsKey(enchantment);
    }

    public int getEnchantment(Enchantment enchantment) {
        return this.enchantments.get(enchantment);
    }

    public boolean shouldHideCape() {
        return this.hideCape;
    }

    public Map<EquipmentSlotType, List<Piece>> getPieces() {
        return this.pieces;
    }

    public List<Piece> getPieces(EquipmentSlotType slot) {
        return this.pieces.get(slot);
    }

    public ExtendedArmorMaterial hidesSecondLayer(boolean head, boolean chest, boolean legs, boolean feet) {
        this.hidesSecondLayer[0] = head;
        this.hidesSecondLayer[1] = chest;
        this.hidesSecondLayer[2] = legs;
        this.hidesSecondLayer[3] = feet;
        return this;
    }

    public boolean[] shouldHideSecondLayer() {
        return this.hidesSecondLayer;
    }
}

