/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import immersive_armors.Main;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BipedArmorLayer.class})
public abstract class MixinArmorFeatureRenderer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    float tickDelta;
    ItemStack equippedStack;
    T entity;

    public MixinArmorFeatureRenderer(IEntityRenderer<T, M> context) {
        super(context);
    }

    @ModifyVariable(method={"renderArmor"}, at=@At(value="STORE"), ordinal=0)
    private ItemStack fetchItemStack(ItemStack itemStack) {
        this.equippedStack = itemStack;
        return itemStack;
    }

    @Inject(method={"renderArmorParts"}, at={@At(value="HEAD")}, cancellable=true)
    void injectRenderArmorParts(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, ArmorItem item, boolean usesSecondLayer, A model, boolean legs, float red, float green, float blue, String overlay, CallbackInfo ci) {
        if (!Main.FORGE && this.equippedStack.func_77973_b() == item && item instanceof ExtendedArmorItem) {
            this.renderPieces(matrices, vertexConsumers, light, (ExtendedArmorItem)item);
            ci.cancel();
        }
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true)
    void injectRenderArmor(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, T entity, EquipmentSlotType armorSlot, int light, A model, CallbackInfo ci) {
        ItemStack itemStack;
        if (Main.FORGE && (itemStack = entity.func_184582_a(armorSlot)).func_77973_b() instanceof ExtendedArmorItem) {
            ci.cancel();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    public void render(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i, T entity, float f, float g, float tickDelta, float j, float k, float l, CallbackInfo ci) {
        this.tickDelta = tickDelta;
        this.entity = entity;
        if (Main.FORGE) {
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlotType.HEAD);
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlotType.CHEST);
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlotType.LEGS);
            this.renderPieces(matrixStack, vertexConsumerProvider, i, EquipmentSlotType.FEET);
        }
    }

    private void renderPieces(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, EquipmentSlotType armorSlot) {
        this.equippedStack = this.entity.func_184582_a(armorSlot);
        if (this.equippedStack.func_77973_b() instanceof ExtendedArmorItem) {
            this.renderPieces(matrices, vertexConsumers, light, (ExtendedArmorItem)this.equippedStack.func_77973_b());
        }
    }

    private void renderPieces(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, ExtendedArmorItem item) {
        item.getMaterial().getPieces(item.func_185083_B_()).forEach(piece -> piece.render(matrices, vertexConsumers, light, (LivingEntity)this.entity, this.equippedStack, this.tickDelta, item.func_185083_B_(), (BipedModel<LivingEntity>)((BipedModel)this.func_215332_c())));
    }
}

