/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.TurretOptionsScreen;
import dev.buildtool.satako.ItemHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class Turret
extends MobEntity
implements IRangedAttackMob,
INamedContainerProvider {
    private static final DataParameter<CompoundNBT> TARGETS = EntityDataManager.func_187226_a(Turret.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(Turret.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> MOVEABLE = EntityDataManager.func_187226_a(Turret.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PROTECTION_FROM_PLAYERS = EntityDataManager.func_187226_a(Turret.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected Predicate<LivingEntity> alienPlayers = livingEntity -> {
        if (this.getOwner().isPresent()) {
            return livingEntity instanceof PlayerEntity && !livingEntity.func_110124_au().equals(this.getOwner().get()) && !livingEntity.func_184191_r((Entity)this.field_70170_p.func_217371_b(this.getOwner().get()));
        }
        return false;
    };

    public Turret(EntityType<? extends MobEntity> entityType, World world) {
        super(entityType, world);
    }

    public static AttributeModifierMap.MutableAttribute createDefaultAttributes() {
        return Turret.func_233639_cI_().func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233826_i_, 3.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        CompoundNBT compoundNBT = new CompoundNBT();
        List targets = ForgeRegistries.ENTITIES.getValues().stream().filter(entityType1 -> !entityType1.func_220339_d().func_75599_d()).collect(Collectors.toList());
        for (int i = 0; i < targets.size(); ++i) {
            compoundNBT.func_74778_a("Target#" + i, ((EntityType)targets.get(i)).getRegistryName().toString());
        }
        compoundNBT.func_74768_a("Count", targets.size());
        this.field_70180_af.func_187214_a(TARGETS, (Object)compoundNBT);
        this.field_70180_af.func_187214_a(OWNER, Optional.empty());
        this.field_70180_af.func_187214_a(MOVEABLE, (Object)false);
        this.field_70180_af.func_187214_a(PROTECTION_FROM_PLAYERS, (Object)false);
    }

    public void setTargets(CompoundNBT compoundNBT) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)compoundNBT);
    }

    public CompoundNBT getTargets() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(TARGETS);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER);
    }

    public void setOwner(UUID owner) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(owner));
    }

    public void setMoveable(boolean moveable) {
        this.field_70180_af.func_187227_b(MOVEABLE, (Object)moveable);
    }

    public boolean isMoveable() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVEABLE);
    }

    public void setProtectionFromPlayers(boolean protect) {
        this.field_70180_af.func_187227_b(PROTECTION_FROM_PLAYERS, (Object)protect);
    }

    public boolean isProtectingFromPlayers() {
        return (Boolean)this.field_70180_af.func_187225_a(PROTECTION_FROM_PLAYERS);
    }

    protected abstract void func_184651_r();

    public boolean func_190631_cK() {
        return false;
    }

    public boolean func_70075_an() {
        return true;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType p_184201_1_, ItemStack p_184201_2_) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    protected double getRange() {
        return this.func_233637_b_(Attributes.field_233819_b_);
    }

    protected double getDamage() {
        return this.func_233637_b_(Attributes.field_233823_f_);
    }

    protected ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand p_230254_2_) {
        ItemStack itemStack = playerEntity.func_184586_b(p_230254_2_);
        if (this.func_110143_aJ() < this.func_110138_aP() && itemStack.func_77973_b().getTags().stream().anyMatch(resourceLocation -> resourceLocation.equals((Object)KTurrets.STEEL_INGOT))) {
            this.func_70691_i(this.func_110138_aP() / 6.0f);
            itemStack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        if (this.canUse(playerEntity)) {
            if (this.field_70170_p.field_72995_K) {
                this.openTargetScreen();
            }
            return ActionResultType.SUCCESS;
        }
        if (this.field_70170_p.field_72995_K) {
            playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("k-turrets.turret.not.yours"), Util.field_240973_b_);
        }
        return ActionResultType.PASS;
    }

    protected boolean canUse(PlayerEntity playerEntity) {
        return !this.getOwner().isPresent() || this.getOwner().get().equals(playerEntity.func_110124_au());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openTargetScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new TurretOptionsScreen(this));
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_218657_a("Targets", (INBT)this.getTargets());
        this.getOwner().ifPresent(uuid1 -> compoundNBT.func_186854_a("Owner", uuid1));
        compoundNBT.func_74757_a("Mobile", this.isMoveable());
        compoundNBT.func_74757_a("Player protection", this.isProtectingFromPlayers());
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        UUID uuid;
        super.func_70037_a(compoundNBT);
        this.setTargets(compoundNBT.func_74775_l("Targets"));
        if (compoundNBT.func_74764_b("Owner") && !(uuid = compoundNBT.func_186857_a("Owner")).equals(Util.field_240973_b_)) {
            this.setOwner(uuid);
        }
        this.setMoveable(compoundNBT.func_74767_n("Mobile"));
        this.setProtectionFromPlayers(compoundNBT.func_74767_n("Player protection"));
    }

    public List<EntityType<?>> decodeTargets(CompoundNBT compoundNBT) {
        int count = compoundNBT.func_74762_e("Count");
        ArrayList list = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            String next = compoundNBT.func_74779_i("Target#" + i);
            list.add((EntityType<?>)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(next)));
        }
        return list;
    }

    public CompoundNBT encodeTargets(List<EntityType<?>> list) {
        CompoundNBT compoundNBT = new CompoundNBT();
        for (int i = 0; i < list.size(); ++i) {
            EntityType<?> entityType = list.get(i);
            compoundNBT.func_74778_a("Target#" + i, entityType.getRegistryName().toString());
        }
        compoundNBT.func_74768_a("Count", list.size());
        return compoundNBT;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.getContainedItems().forEach(itemHandler -> InventoryHelper.func_219961_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (NonNullList)itemHandler.getItems()));
    }

    protected abstract List<ItemHandler> getContainedItems();

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187767_eL;
    }

    public boolean func_70687_e(EffectInstance effectInstance) {
        Effect effect = effectInstance.func_188419_a();
        if (effect == Effects.field_76436_u || effect == Effects.field_76432_h || effect == Effects.field_180152_w || effect == Effects.field_76428_l || effect == Effects.field_82731_v || effect == Effects.field_76438_s) {
            return false;
        }
        return super.func_70687_e(effectInstance);
    }

    public boolean func_241845_aY() {
        return !this.isMoveable();
    }

    public boolean func_70104_M() {
        return this.isMoveable();
    }

    public void func_233627_a_(float p_233627_1_, double p_233627_2_, double p_233627_4_) {
        if (this.isMoveable()) {
            super.func_233627_a_(p_233627_1_, p_233627_2_, p_233627_4_);
        }
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187523_aM;
    }

    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    public Item getSpawnItem() {
        return ForgeSpawnEggItem.fromEntityType((EntityType)this.func_200600_R());
    }

    public abstract boolean isArmed();

    public boolean func_180431_b(DamageSource p_180431_1_) {
        Entity source = p_180431_1_.func_76346_g();
        if (source instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)source;
            return this.getOwner().isPresent() && this.getOwner().get().equals(player.func_110124_au());
        }
        return super.func_180431_b(p_180431_1_);
    }

    public boolean func_184191_r(Entity target) {
        if (target instanceof Turret) {
            Turret turret = (Turret)target;
            return turret.getOwner().isPresent() && turret.getOwner().equals(this.getOwner());
        }
        if (this.getOwner().isPresent() && this.getOwner().get().equals(target.func_110124_au())) {
            return true;
        }
        return super.func_184191_r(target);
    }
}

