/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.packets.ClaimTurret;
import dev.buildtool.kturrets.packets.DismantleTurret;
import dev.buildtool.kturrets.packets.ToggleMobility;
import dev.buildtool.kturrets.packets.TogglePlayerProtection;
import dev.buildtool.kturrets.packets.TurretTargets;
import dev.buildtool.satako.UniqueList;
import dev.buildtool.satako.gui.BetterButton;
import dev.buildtool.satako.gui.Label;
import dev.buildtool.satako.gui.Screen2;
import dev.buildtool.satako.gui.SwitchButton;
import dev.buildtool.satako.gui.TextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class TurretOptionsScreen
extends Screen2 {
    protected Turret turret;
    protected HashMap<EntityType<?>, Boolean> tempStatusMap;
    protected List<EntityType<?>> targets;
    private static final TranslationTextComponent CHOOSE_HINT = new TranslationTextComponent("k-turrets.choose.tooltip");
    private static final TranslationTextComponent SCROLL_HINT = new TranslationTextComponent("k-turrets.hold.alt.to.scroll");
    private static final TranslationTextComponent INVENTORY_HINT = new TranslationTextComponent("k-turrets.inventory.hint");
    private List<SwitchButton> targetButtons;
    private TextField addEntityField;

    public TurretOptionsScreen(Turret turret) {
        super((ITextComponent)new TranslationTextComponent("k-turrets.targets"));
        this.turret = turret;
        this.tempStatusMap = new HashMap(40);
        this.targets = new UniqueList(turret.decodeTargets(turret.getTargets()));
        this.targets.forEach(entityType -> this.tempStatusMap.put((EntityType<?>)entityType, true));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.addEntityField = (TextField)this.func_230480_a_((Widget)new TextField(this.centerX, 3, 100));
        this.func_230480_a_((Widget)new BetterButton(this.centerX, 20, (ITextComponent)new TranslationTextComponent("k-turrets.add.entity.type"), p_onPress_1_ -> {
            String entityType = this.addEntityField.func_146179_b();
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityType));
            if (entityType.length() > 2 && type != null) {
                if (type == EntityType.field_200784_X && !entityType.equals("minecraft:pig") && !entityType.equals("pig")) {
                    this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("k-turrets.incorrect.entry"), Util.field_240973_b_);
                } else {
                    this.targets.add(type);
                    this.tempStatusMap.put(type, true);
                    this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("k-turrets.added").func_240702_b_(" ").func_230529_a_(type.func_212546_e()), Util.field_240973_b_);
                    if (entityType.contains(":")) {
                        this.addEntityField.func_146180_a(entityType.substring(0, entityType.indexOf(58)));
                    }
                }
            }
        }));
        this.func_230480_a_((Widget)new BetterButton(this.centerX, 40, (ITextComponent)new TranslationTextComponent("k-turrets.dismantle"), p_onPress_1_ -> {
            KTurrets.channel.sendToServer((Object)new DismantleTurret(this.turret.func_145782_y()));
            this.field_230706_i_.field_71439_g.func_71053_j();
        }));
        this.func_230480_a_((Widget)new BetterButton(this.centerX, 60, (ITextComponent)new TranslationTextComponent("k-turrets.clear.list"), p_onPress_1_ -> {
            this.targets.clear();
            this.tempStatusMap.clear();
            this.targetButtons.forEach(this.field_230710_m_::remove);
        }));
        this.func_230480_a_((Widget)new SwitchButton(this.centerX, 80, (ITextComponent)new TranslationTextComponent("k-turrets.mobile"), (ITextComponent)new TranslationTextComponent("k-turrets.immobile"), this.turret.isMoveable(), p_onPress_1_ -> {
            KTurrets.channel.sendToServer((Object)new ToggleMobility(!this.turret.isMoveable(), this.turret.func_145782_y()));
            this.turret.setMoveable(!this.turret.isMoveable());
            if (p_onPress_1_ instanceof SwitchButton) {
                ((SwitchButton)p_onPress_1_).state = !((SwitchButton)p_onPress_1_).state;
            }
        }));
        this.func_230480_a_((Widget)new SwitchButton(this.centerX, 100, (ITextComponent)new TranslationTextComponent("k-turrets.protect.from.players"), (ITextComponent)new TranslationTextComponent("k-turrets.not.protect.from.players"), this.turret.isProtectingFromPlayers(), p_onPress_1_ -> {
            KTurrets.channel.sendToServer((Object)new TogglePlayerProtection(!this.turret.isProtectingFromPlayers(), this.turret.func_145782_y()));
            this.turret.setProtectionFromPlayers(!this.turret.isProtectingFromPlayers());
            if (p_onPress_1_ instanceof SwitchButton) {
                ((SwitchButton)p_onPress_1_).state = !((SwitchButton)p_onPress_1_).state;
            }
        }));
        if (!this.turret.getOwner().isPresent()) {
            this.func_230480_a_((Widget)new BetterButton(this.centerX, 120, (ITextComponent)new TranslationTextComponent("k-turrets.claim.turret"), p_onPress_1_ -> {
                KTurrets.channel.sendToServer((Object)new ClaimTurret(this.turret.func_145782_y(), this.field_230706_i_.field_71439_g.func_110124_au()));
                this.turret.setOwner(this.field_230706_i_.field_71439_g.func_110124_au());
                this.field_230706_i_.field_71439_g.func_71053_j();
            }));
        }
        this.func_230480_a_((Widget)new Label(3, 3, (ITextComponent)new TranslationTextComponent("k-turrets.targets")));
        this.targetButtons = new ArrayList<SwitchButton>(this.targets.size());
        for (int i = 0; i < this.targets.size(); ++i) {
            EntityType<?> entityType = this.targets.get(i);
            SwitchButton switchButton = new SwitchButton(3, 20 * i + 40, (ITextComponent)new StringTextComponent(entityType.getRegistryName().toString()), (ITextComponent)new StringTextComponent(TextFormatting.STRIKETHROUGH + entityType.getRegistryName().toString()), true, p_onPress_1_ -> {
                if (p_onPress_1_ instanceof SwitchButton) {
                    ((SwitchButton)p_onPress_1_).state = !((SwitchButton)p_onPress_1_).state;
                    this.tempStatusMap.put(entityType, ((SwitchButton)p_onPress_1_).state);
                }
            });
            switchButton.verticalScroll = true;
            this.func_230480_a_((Widget)switchButton);
            this.targetButtons.add(switchButton);
        }
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.tempStatusMap.forEach((entityType, aBoolean) -> {
            if (aBoolean.booleanValue()) {
                this.targets.add((EntityType<?>)entityType);
            } else {
                this.targets.remove(entityType);
            }
        });
        CompoundNBT compoundNBT = this.turret.encodeTargets(this.targets);
        this.turret.setTargets(compoundNBT);
        TurretTargets turretTargets = new TurretTargets(compoundNBT, this.turret.func_145782_y());
        KTurrets.channel.sendToServer((Object)turretTargets);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float tick) {
        List entityTypes;
        super.func_230430_a_(matrixStack, mouseX, mouseY, tick);
        this.renderWrappedToolTip(matrixStack, Collections.singletonList(new TranslationTextComponent("k-turrets.integrity").func_240702_b_(": " + (int)this.turret.func_110143_aJ() + "/" + this.turret.func_110138_aP())), this.centerX, this.centerY + 40, this.field_230712_o_);
        this.renderWrappedToolTip(matrixStack, Arrays.asList(CHOOSE_HINT, SCROLL_HINT, INVENTORY_HINT), this.centerX, this.centerY + 60, this.field_230712_o_);
        String targetEntry = this.addEntityField.func_146179_b();
        if (targetEntry.length() > 0 && !(entityTypes = targetEntry.contains(":") ? ForgeRegistries.ENTITIES.getKeys().stream().filter(resourceLocation -> resourceLocation.toString().contains(targetEntry)).collect(Collectors.toList()) : ForgeRegistries.ENTITIES.getKeys().stream().filter(resourceLocation -> resourceLocation.func_110624_b().contains(targetEntry)).collect(Collectors.toList())).isEmpty()) {
            this.func_243308_b(matrixStack, entityTypes.subList(0, Math.min(entityTypes.size(), 12)).stream().map(resourceLocation -> new StringTextComponent(TextFormatting.YELLOW + resourceLocation.toString())).collect(Collectors.toList()), this.addEntityField.field_230690_l_, this.addEntityField.field_230691_m_ + this.addEntityField.func_238483_d_() + 20);
        }
    }
}

