/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets.arrow;

import dev.buildtool.kturrets.AttackTargetGoal;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.arrow.Arrow2;
import dev.buildtool.kturrets.arrow.ArrowTurretContainer;
import dev.buildtool.kturrets.registers.TEntities;
import dev.buildtool.satako.ItemHandler;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ArrowTurret
extends Turret {
    protected final ItemHandler weapon = new ItemHandler(1){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() instanceof BowItem || stack.func_77973_b() instanceof CrossbowItem) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    protected final ItemHandler ammo = new ItemHandler(27){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_77973_b() instanceof ArrowItem) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };

    public ArrowTurret(World world) {
        super(TEntities.ARROW_TURRET, world);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack weapon;
        if (target.func_70089_S() && !(weapon = this.weapon.getStackInSlot(0)).func_190926_b()) {
            for (ItemStack arrows : this.ammo.getItems()) {
                if (!(arrows.func_77973_b() instanceof ArrowItem)) continue;
                AbstractArrowEntity arrowEntity = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)arrows, (float)distanceFactor);
                double d0 = target.func_226277_ct_() - this.func_226277_ct_();
                double d1 = target.func_226280_cw_() - this.func_226280_cw_();
                double d2 = target.func_226281_cx_() - this.func_226281_cx_();
                arrowEntity.func_70186_c(d0, d1, d2, 1.8f, 0.0f);
                double damage = ((Integer)KTurrets.ARROW_TURRET_DAMAGE.get()).intValue();
                arrowEntity.func_70239_b(damage);
                Arrow2 arrow2 = new Arrow2(this.field_70170_p, arrowEntity, (LivingEntity)this, distanceFactor);
                if (weapon.func_77973_b() instanceof BowItem) {
                    arrow2.func_70239_b(arrowEntity.func_70242_d());
                } else if (weapon.func_77973_b() instanceof CrossbowItem) {
                    arrow2.func_70239_b(arrowEntity.func_70242_d() * 1.2);
                    arrow2.func_213865_o(true);
                    int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)weapon);
                    if (i > 0) {
                        arrow2.func_213872_b((byte)i);
                    }
                }
                arrow2.func_190547_a((LivingEntity)this, distanceFactor);
                arrow2.func_189654_d(true);
                this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_217376_c((Entity)arrow2);
                arrows.func_190918_g(1);
                weapon.func_222118_a(1, (LivingEntity)this, turret -> turret.func_213334_d(Hand.MAIN_HAND));
                break;
            }
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.weapon.deserializeNBT(compoundNBT.func_74775_l("Weapon"));
        this.ammo.deserializeNBT(compoundNBT.func_74775_l("Ammo"));
    }

    @Override
    protected List<ItemHandler> getContainedItems() {
        return Arrays.asList(this.weapon, this.ammo);
    }

    @Override
    public boolean isArmed() {
        return !this.ammo.isEmpty() && !this.weapon.isEmpty();
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_218657_a("Ammo", (INBT)this.ammo.serializeNBT());
        compoundNBT.func_218657_a("Weapon", (INBT)this.weapon.serializeNBT());
    }

    @Nullable
    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
        packetBuffer.writeInt(this.func_145782_y());
        return new ArrowTurretContainer(p_createMenu_1_, p_createMenu_2_, packetBuffer);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 0.0, ((Integer)KTurrets.ARROW_TURRET_RATE.get()).intValue(), (float)this.getRange()));
        this.field_70715_bh.func_75776_a(5, (Goal)new AttackTargetGoal(this));
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand p_230254_2_) {
        if (this.canUse(playerEntity) && !playerEntity.func_225608_bj_()) {
            if (playerEntity instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)this, packetBuffer -> packetBuffer.writeInt(this.func_145782_y()));
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(playerEntity, p_230254_2_);
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType p_184582_1_) {
        return this.weapon.getStackInSlot(0);
    }
}

