/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec3Argument;
import net.minecraft.command.impl.SetBlockCommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.command.EnumArgument;

@Mod.EventBusSubscriber
public class Commands {
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_208897_0_, p_208897_1_) -> new TranslationTextComponent("commands.fill.toobig", new Object[]{p_208897_0_, p_208897_1_}));
    private static final BlockStateInput HOLLOW_CORE = new BlockStateInput(Blocks.field_150350_a.func_176223_P(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.fill.failed"));

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent registerCommandsEvent) {
        CommandDispatcher commandDispatcher = registerCommandsEvent.getDispatcher();
        RootCommandNode rootCommandNode = commandDispatcher.getRoot();
        LiteralArgumentBuilder summon2 = (LiteralArgumentBuilder)net.minecraft.command.Commands.func_197057_a((String)"summon2").requires(commandSource -> commandSource.func_197034_c(2));
        SuggestionProvider namespaces = (context, builder) -> ISuggestionProvider.func_197013_a(ForgeRegistries.ENTITIES.getValues().stream().map(entityType -> entityType.getRegistryName().func_110624_b()), (SuggestionsBuilder)builder);
        SuggestionProvider entities = (context, builder) -> ISuggestionProvider.func_197013_a(ForgeRegistries.ENTITIES.getValues().stream().filter(entityType -> ((String)context.getArgument("namespace", String.class)).equals(entityType.getRegistryName().func_110624_b())).map(entityType -> entityType.getRegistryName().func_110623_a()), (SuggestionsBuilder)builder);
        RequiredArgumentBuilder namespace = net.minecraft.command.Commands.func_197056_a((String)"namespace", (ArgumentType)StringArgumentType.string()).suggests(namespaces);
        RequiredArgumentBuilder entityName = net.minecraft.command.Commands.func_197056_a((String)"entity", (ArgumentType)StringArgumentType.string()).suggests(entities);
        entityName.executes(context -> {
            ResourceLocation resourceLocation = new ResourceLocation((String)context.getArgument("namespace", String.class), (String)context.getArgument("entity", String.class));
            CommandSource commandSource = (CommandSource)context.getSource();
            return Commands.summonEntity(commandSource, commandSource.func_197036_d().func_72441_c(0.5, 0.0, 0.5), resourceLocation);
        });
        RequiredArgumentBuilder position = net.minecraft.command.Commands.func_197056_a((String)"position", (ArgumentType)Vec3Argument.func_197303_a((boolean)true));
        position.executes(context -> {
            ResourceLocation resourceLocation = new ResourceLocation((String)context.getArgument("namespace", String.class), (String)context.getArgument("entity", String.class));
            CommandSource commandSource = (CommandSource)context.getSource();
            Vector3d vector3d = Vec3Argument.func_197300_a((CommandContext)context, (String)"position");
            return Commands.summonEntity(commandSource, vector3d, resourceLocation);
        });
        LiteralCommandNode built = summon2.build();
        ArgumentCommandNode domain = namespace.build();
        ArgumentCommandNode name = entityName.build();
        built.addChild((CommandNode)domain);
        domain.addChild((CommandNode)name);
        name.addChild((CommandNode)position.build());
        rootCommandNode.addChild((CommandNode)built);
        SuggestionProvider blockMods = (context, builder) -> ISuggestionProvider.func_197013_a(ForgeRegistries.BLOCKS.getKeys().stream().map(ResourceLocation::func_110624_b), (SuggestionsBuilder)builder);
        SuggestionProvider blockNames = (context, builder) -> ISuggestionProvider.func_197013_a(ForgeRegistries.BLOCKS.getKeys().stream().filter(resourceLocation -> resourceLocation.func_110624_b().equals(context.getArgument("mod", String.class))).map(ResourceLocation::func_110623_a), (SuggestionsBuilder)builder);
        LiteralArgumentBuilder fill2 = (LiteralArgumentBuilder)net.minecraft.command.Commands.func_197057_a((String)"fill2").requires(commandSource -> commandSource.func_197034_c(2));
        RequiredArgumentBuilder from = net.minecraft.command.Commands.func_197056_a((String)"from", (ArgumentType)BlockPosArgument.func_197276_a());
        RequiredArgumentBuilder to = net.minecraft.command.Commands.func_197056_a((String)"to", (ArgumentType)BlockPosArgument.func_197276_a());
        RequiredArgumentBuilder nameSpace = net.minecraft.command.Commands.func_197056_a((String)"mod", (ArgumentType)StringArgumentType.string()).suggests(blockMods);
        RequiredArgumentBuilder path = net.minecraft.command.Commands.func_197056_a((String)"block", (ArgumentType)StringArgumentType.string()).suggests(blockNames);
        path.executes(context -> Commands.fillBlocks((CommandSource)context.getSource(), new MutableBoundingBox((Vector3i)BlockPosArgument.func_197273_a((CommandContext)context, (String)"from"), (Vector3i)BlockPosArgument.func_197273_a((CommandContext)context, (String)"to")), (String)context.getArgument("mod", String.class), (String)context.getArgument("block", String.class), Mode.REPLACE, null));
        RequiredArgumentBuilder mode = net.minecraft.command.Commands.func_197056_a((String)"filter", (ArgumentType)EnumArgument.enumArgument(Mode.class));
        mode.executes(context -> {
            Mode mode1 = (Mode)((Object)((Object)context.getArgument("filter", Mode.class)));
            return Commands.fillBlocks((CommandSource)context.getSource(), new MutableBoundingBox((Vector3i)BlockPosArgument.func_197273_a((CommandContext)context, (String)"from"), (Vector3i)BlockPosArgument.func_197273_a((CommandContext)context, (String)"to")), (String)context.getArgument("mod", String.class), (String)context.getArgument("block", String.class), mode1, null);
        });
        LiteralCommandNode fill = fill2.build();
        ArgumentCommandNode start = from.build();
        ArgumentCommandNode end = to.build();
        ArgumentCommandNode mod = nameSpace.build();
        ArgumentCommandNode block = path.build();
        fill.addChild((CommandNode)start);
        start.addChild((CommandNode)end);
        end.addChild((CommandNode)mod);
        mod.addChild((CommandNode)block);
        block.addChild((CommandNode)mode.build());
        rootCommandNode.addChild((CommandNode)fill);
        SuggestionProvider mods = (context, builder) -> ISuggestionProvider.func_197005_b(() -> ForgeRegistries.ITEMS.getKeys().stream().map(ResourceLocation::func_110624_b).collect(Collectors.toSet()).iterator(), (SuggestionsBuilder)builder);
        SuggestionProvider items = (context, builder) -> ISuggestionProvider.func_197005_b(() -> ForgeRegistries.ITEMS.getKeys().stream().filter(resourceLocation -> resourceLocation.func_110624_b().equals(context.getArgument("mod", String.class))).map(ResourceLocation::func_110623_a).collect(Collectors.toSet()).iterator(), (SuggestionsBuilder)builder);
        LiteralArgumentBuilder give2 = (LiteralArgumentBuilder)net.minecraft.command.Commands.func_197057_a((String)"give2").requires(commandSource -> commandSource.func_197034_c(2));
        RequiredArgumentBuilder targets = net.minecraft.command.Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d());
        RequiredArgumentBuilder itemmod = net.minecraft.command.Commands.func_197056_a((String)"mod", (ArgumentType)StringArgumentType.string()).suggests(mods);
        RequiredArgumentBuilder itemPath = net.minecraft.command.Commands.func_197056_a((String)"item", (ArgumentType)StringArgumentType.string()).suggests(items);
        itemPath.executes(context -> Commands.giveItems((CommandContext<CommandSource>)context, 1));
        RequiredArgumentBuilder count = net.minecraft.command.Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1));
        count.executes(context -> Commands.giveItems((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"count")));
        LiteralCommandNode giveNode = give2.build();
        ArgumentCommandNode players = targets.build();
        ArgumentCommandNode itemDomain = itemmod.build();
        ArgumentCommandNode item = itemPath.build();
        ArgumentCommandNode countNode = count.build();
        giveNode.addChild((CommandNode)players);
        players.addChild((CommandNode)itemDomain);
        itemDomain.addChild((CommandNode)item);
        item.addChild((CommandNode)countNode);
        rootCommandNode.addChild((CommandNode)giveNode);
    }

    private static int giveItems(CommandContext<CommandSource> context, int amount) throws CommandSyntaxException {
        String itemName;
        String modName = (String)context.getArgument("mod", String.class);
        ResourceLocation resourceLocation = new ResourceLocation(modName, itemName = (String)context.getArgument("item", String.class));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        if (item != null) {
            Collection serverPlayerEntities = EntityArgument.func_197090_e(context, (String)"targets");
            for (ServerPlayerEntity serverplayerentity : serverPlayerEntities) {
                int i = amount;
                while (i > 0) {
                    int j = Math.min(item.func_77639_j(), i);
                    i -= j;
                    ItemStack itemstack = new ItemStack((IItemProvider)item, j);
                    boolean flag = serverplayerentity.field_71071_by.func_70441_a(itemstack);
                    if (flag && itemstack.func_190926_b()) {
                        itemstack.func_190920_e(1);
                        ItemEntity itementity1 = serverplayerentity.func_71019_a(itemstack, false);
                        if (itementity1 != null) {
                            itementity1.func_174870_v();
                        }
                        serverplayerentity.field_70170_p.func_184148_a(null, serverplayerentity.func_226277_ct_(), serverplayerentity.func_226278_cu_(), serverplayerentity.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((serverplayerentity.func_70681_au().nextFloat() - serverplayerentity.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        serverplayerentity.field_71069_bz.func_75142_b();
                        continue;
                    }
                    ItemEntity itementity = serverplayerentity.func_71019_a(itemstack, false);
                    if (itementity == null) continue;
                    itementity.func_174868_q();
                    itementity.func_200217_b(serverplayerentity.func_110124_au());
                }
            }
        }
        return 1;
    }

    private static int fillBlocks(CommandSource source, MutableBoundingBox mutableBoundingBox, String mod, String block, Mode mode, Predicate<CachedBlockInfo> o) throws CommandSyntaxException {
        int i = mutableBoundingBox.func_78883_b() * mutableBoundingBox.func_78882_c() * mutableBoundingBox.func_78880_d();
        if (i > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)i);
        }
        ArrayList list = Lists.newArrayList();
        ServerWorld serverworld = source.func_197023_e();
        int j = 0;
        Block block1 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mod, block));
        for (BlockPos blockpos : BlockPos.func_191531_b((int)mutableBoundingBox.field_78897_a, (int)mutableBoundingBox.field_78895_b, (int)mutableBoundingBox.field_78896_c, (int)mutableBoundingBox.field_78893_d, (int)mutableBoundingBox.field_78894_e, (int)mutableBoundingBox.field_78892_f)) {
            BlockStateInput stateInput;
            if (o != null && !o.test(new CachedBlockInfo((IWorldReader)serverworld, blockpos, true)) || (stateInput = mode.filter.filter(mutableBoundingBox, blockpos, new BlockStateInput(block1.func_176223_P(), Collections.emptySet(), null), serverworld)) == null) continue;
            TileEntity tileEntity = serverworld.func_175625_s(blockpos);
            IClearable.func_213131_a((Object)tileEntity);
            if (!serverworld.func_175656_a(blockpos, block1.func_176223_P())) continue;
            list.add(blockpos.func_185334_h());
            ++j;
        }
        for (BlockPos blockpos1 : list) {
            Block b = serverworld.func_180495_p(blockpos1).func_177230_c();
            serverworld.func_230547_a_(blockpos1, b);
        }
        if (j == 0) {
            throw ERROR_FAILED.create();
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.fill.success", new Object[]{j}), true);
        return j;
    }

    private static int summonEntity(CommandSource commandSource, Vector3d position, ResourceLocation resourceLocation) {
        ServerWorld serverWorld = commandSource.func_197023_e().getWorldServer();
        Entity entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation)).func_200721_a((World)serverWorld);
        if (entity == null) {
            commandSource.func_197030_a((ITextComponent)new StringTextComponent("No entity " + resourceLocation.toString()), false);
            return -1;
        }
        entity.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_213386_a((IServerWorld)serverWorld, serverWorld.func_175649_E(entity.func_233580_cy_()), SpawnReason.COMMAND, null, null);
        }
        serverWorld.func_217376_c(entity);
        commandSource.func_197030_a((ITextComponent)new StringTextComponent("Summoned " + entity.func_200200_C_().getString() + " at " + (int)position.field_72450_a + " " + (int)position.field_72448_b + " " + (int)position.field_72449_c), true);
        return 1;
    }

    static enum Mode {
        REPLACE((p_198450_0_, p_198450_1_, p_198450_2_, p_198450_3_) -> p_198450_2_),
        OUTLINE((mutableBoundingBox, blockPos, blockStateInput, p_198454_3_) -> blockPos.func_177958_n() != mutableBoundingBox.field_78897_a && blockPos.func_177958_n() != mutableBoundingBox.field_78893_d && blockPos.func_177956_o() != mutableBoundingBox.field_78895_b && blockPos.func_177956_o() != mutableBoundingBox.field_78894_e && blockPos.func_177952_p() != mutableBoundingBox.field_78896_c && blockPos.func_177952_p() != mutableBoundingBox.field_78892_f ? null : blockStateInput),
        HOLLOW((p_198453_0_, p_198453_1_, p_198453_2_, p_198453_3_) -> p_198453_1_.func_177958_n() != p_198453_0_.field_78897_a && p_198453_1_.func_177958_n() != p_198453_0_.field_78893_d && p_198453_1_.func_177956_o() != p_198453_0_.field_78895_b && p_198453_1_.func_177956_o() != p_198453_0_.field_78894_e && p_198453_1_.func_177952_p() != p_198453_0_.field_78896_c && p_198453_1_.func_177952_p() != p_198453_0_.field_78892_f ? HOLLOW_CORE : p_198453_2_),
        DESTROY((p_198452_0_, p_198452_1_, p_198452_2_, p_198452_3_) -> {
            p_198452_3_.func_175655_b(p_198452_1_, true);
            return p_198452_2_;
        });

        public final SetBlockCommand.IFilter filter;

        private Mode(SetBlockCommand.IFilter p_i47985_3_) {
            this.filter = p_i47985_3_;
        }
    }
}

