/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.Constants;
import dev.buildtool.satako.ItemHandler;
import dev.buildtool.satako.Methods;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.AirItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public final class Functions {
    public static BlockPos findAirAbove(IServerWorld serverWorld, BlockPos start) {
        while (!serverWorld.func_175623_d(start) && (start = start.func_177984_a()).func_177956_o() >= 2 && start.func_177956_o() <= serverWorld.func_234938_ad_() - 2) {
        }
        return start;
    }

    public static BlockPos findAirBelow(IServerWorld serverWorld, BlockPos start) {
        while (!serverWorld.func_175623_d(start) && (start = start.func_177977_b()).func_177956_o() >= 2 && start.func_177956_o() <= serverWorld.func_234938_ad_() - 2) {
        }
        return start;
    }

    public static boolean isPlayerInSurvivalMode(PlayerEntity entityPlayer) {
        return !entityPlayer.func_175149_v() && !entityPlayer.func_184812_l_();
    }

    public static boolean isSurvivalPlayer(Entity entity) {
        return entity instanceof PlayerEntity && Functions.isPlayerInSurvival((PlayerEntity)entity);
    }

    public static float getDefaultXRightLimbRotation(float limbSwing, float swingAmount) {
        return MathHelper.func_76134_b((float)((float)((double)limbSwing + Math.PI))) * swingAmount;
    }

    public static float getDefaultXLeftLimbRotation(float limbSwing, float swingAmount) {
        return MathHelper.func_76134_b((float)limbSwing) * swingAmount;
    }

    public static float getDefaultHeadYaw(float netYaw) {
        return netYaw * ((float)Math.PI / 180);
    }

    public static float getDefaultHeadPitch(float pitch) {
        return pitch * ((float)Math.PI / 180);
    }

    public static boolean isInSightOf(Entity watched, LivingEntity watcher, float angleRange) {
        float threshold;
        assert (angleRange <= 180.0f);
        Vector3d vecOne = new Vector3d(watched.func_226277_ct_() - watcher.func_226277_ct_(), watched.func_226278_cu_() + watched.func_174824_e((float)1.0f).field_72448_b - watcher.func_226278_cu_() - watcher.func_174824_e((float)1.0f).field_72448_b, watched.func_226281_cx_() - watcher.func_226281_cx_()).func_72432_b();
        Vector3d vecTwo = watcher.func_70676_i(1.0f).func_72432_b();
        double dotproduct = vecTwo.func_72430_b(vecOne);
        if (dotproduct > (double)(threshold = (180.0f - angleRange) / 180.0f)) {
            return watcher.func_70685_l(watched);
        }
        return false;
    }

    public static BlockPos performBlockRayTrace(Entity from, double distance, World world) {
        Vector3d eyesPosition = from.func_174824_e(1.0f);
        Vector3d look = from.func_70040_Z();
        BlockPos blockPos = new BlockPos(eyesPosition);
        while (world.func_175623_d(blockPos)) {
            eyesPosition = eyesPosition.func_178787_e(look);
            blockPos = new BlockPos(eyesPosition);
            double dist = from.func_70092_e(eyesPosition.field_72450_a, eyesPosition.field_72448_b, eyesPosition.field_72449_c);
            if (!(dist >= distance * distance)) continue;
            break;
        }
        return blockPos;
    }

    public static boolean isThereSpaceInAHandler(IItemHandler iItemHandler, boolean allowPartialStack) {
        for (int i = 0; i < iItemHandler.getSlots(); ++i) {
            ItemStack itemStack = iItemHandler.getStackInSlot(i);
            if (!itemStack.func_190926_b() && (!allowPartialStack || itemStack.func_190916_E() >= itemStack.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectionalBlockPowered(Direction blockDirection, BlockPos blockPosition, BlockPos pulsePosition, World world) {
        BlockState backstate;
        Direction back = blockDirection.func_176734_d();
        BlockPos backPosition = blockPosition.func_177972_a(back);
        if (pulsePosition.equals((Object)backPosition) && (backstate = world.func_180495_p(backPosition)).func_185897_m()) {
            return world.func_175709_b(backPosition, back);
        }
        return false;
    }

    public static Direction getPowerIncomingDirection(BlockPos pulsePosition, BlockPos target, Block notifier, World world) {
        BlockState source = world.func_180495_p(pulsePosition);
        for (Direction value : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.func_177972_a(value);
            if (!sidepos.equals((Object)pulsePosition) || (sidestate = world.func_180495_p(sidepos)) != source || notifier != sidestate.func_177230_c() || sidestate.func_185893_b((IBlockReader)world, sidepos, value) <= 0) continue;
            return value;
        }
        return null;
    }

    public static int getDirectPower(BlockPos source, BlockPos target, Block notifier, World world) {
        BlockState sourceState = world.func_180495_p(source);
        for (Direction enumFacing : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.func_177972_a(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.func_180495_p(sidepos)) != sourceState || notifier != sidestate.func_177230_c()) continue;
            return sidestate.func_185893_b((IBlockReader)world, sidepos, enumFacing);
        }
        return 0;
    }

    public static boolean isNotifierAdjacent(BlockPos source, BlockPos target, Block notifier, World world) {
        BlockState sourceState = world.func_180495_p(source);
        for (Direction enumFacing : Direction.values()) {
            BlockState sidestate;
            BlockPos sidepos = target.func_177972_a(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.func_180495_p(sidepos)) != sourceState || notifier != sidestate.func_177230_c()) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getBlockPositionFrom(ChunkPos chunkPos) {
        return new BlockPos(chunkPos.field_77276_a << 4, 0, chunkPos.field_77275_b << 4);
    }

    public static float degreesToRadians(float degrees) {
        return (float)((double)degrees * Math.PI / 180.0);
    }

    public static float translateToXcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 0.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return -1.0f;
        }
        return MathHelper.func_76134_b((float)Functions.degreesToRadians(degrees));
    }

    public static float translateToZcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 1.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return 0.0f;
        }
        return MathHelper.func_76126_a((float)Functions.degreesToRadians(degrees));
    }

    public static boolean canGenerateWithoutCascade(IServerWorld world, BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        int cx = chunkPos.field_77276_a;
        int cz = chunkPos.field_77275_b;
        ChunkStatus empty = ChunkStatus.field_223226_a_;
        return world.func_212866_a_(cx, cz).func_201589_g() != empty && world.func_212866_a_(cx + 1, cz).func_201589_g() != empty && world.func_212866_a_(cx - 1, cz).func_201589_g() != empty && world.func_212866_a_(cx, cz + 1).func_201589_g() != empty && world.func_212866_a_(cx, cz - 1).func_201589_g() != empty;
    }

    public static BlockPos getTopBlockPosition(BlockPos pos, World world) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), world.func_234938_ad_() - 16, pos.func_177952_p());
        BlockState nextstate = world.func_180495_p(blockpos);
        while (nextstate == Blocks.field_150350_a.func_176223_P()) {
            blockpos = blockpos.func_177977_b();
            nextstate = world.func_180495_p(blockpos);
        }
        return blockpos;
    }

    @Nullable
    public static Entity findEntityOnPath(World world, Entity watcher) {
        Entity entity = null;
        Vector3d position = watcher.func_174824_e(1.0f);
        Vector3d look = watcher.func_70040_Z();
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(new BlockPos(watcher.func_226277_ct_(), watcher.func_226278_cu_(), watcher.func_226281_cx_())).func_186662_g(7.0);
        List entities = world.func_72839_b(watcher, axisAlignedBB);
        int counter = 0;
        block0: while (true) {
            position = position.func_178787_e(look);
            for (Entity entity1 : entities) {
                if (!entity1.func_174813_aQ().func_72318_a(position)) continue;
                entity = entity1;
                break block0;
            }
            if (counter > 10) break;
            ++counter;
        }
        return entity;
    }

    public static boolean writeUUID(CompoundNBT nbtTagCompound, String key, UUID uuid) {
        if (uuid != null && !uuid.equals(Constants.NULL_UUID)) {
            nbtTagCompound.func_186854_a(key, uuid);
            return true;
        }
        return false;
    }

    public static UUID readUUID(CompoundNBT nbtTagCompound, String key) {
        UUID uuid = nbtTagCompound.func_186857_a(key);
        return uuid.equals(Constants.NULL_UUID) ? null : uuid;
    }

    public static int readEnum(CompoundNBT compound, String key) {
        return compound.func_74771_c(key);
    }

    public static boolean isLiquid(World world, BlockPos pos) {
        FluidState fluidState = world.func_204610_c(pos);
        Fluid fluid = fluidState.func_206886_c();
        return fluid != Fluids.field_204541_a;
    }

    public static boolean isFlowingLiquid(World world, BlockPos position) {
        FluidState fluidState = world.func_204610_c(position);
        Fluid fluid = fluidState.func_206886_c();
        return fluid != Fluids.field_204541_a && !fluid.func_207193_c(fluidState);
    }

    public static boolean isLiquidSource(World world, BlockPos position) {
        FluidState fluidState = world.func_204610_c(position);
        Fluid fluid = fluidState.func_206886_c();
        return fluid != Fluids.field_204541_a && fluid.func_207193_c(fluidState);
    }

    public static boolean isLookingAtHead(LivingEntity watcher, Entity target) {
        Vector3d lookvector = watcher.func_70676_i(1.0f).func_72432_b();
        Vector3d positionvector = new Vector3d(target.func_226277_ct_() - watcher.func_226277_ct_(), watcher.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - (watcher.func_226278_cu_() + (double)watcher.func_70047_e()), target.func_226281_cx_() - watcher.func_226281_cx_());
        double lengthVector = positionvector.func_72433_c();
        double dotProduct = lookvector.func_72430_b(positionvector = positionvector.func_72432_b());
        if (dotProduct > 1.0 - 0.025 / lengthVector) {
            return watcher.func_70685_l(target);
        }
        return false;
    }

    public static HashSet<BlockPos> getConnectedBlocks(Block of, Direction[] checkedSides, BlockPos pos, World world, HashSet<BlockPos> positions, int limit) {
        assert (limit > 1) : "Limit must be >1";
        if (world.func_180495_p(pos).func_177230_c() == of) {
            positions.add(pos);
        }
        if (positions.size() >= limit) {
            return positions;
        }
        for (Direction checkedSide : checkedSides) {
            BlockPos side = pos.func_177972_a(checkedSide);
            BlockState next = world.func_180495_p(side);
            Block block = next.func_177230_c();
            if (block != of) continue;
            if (!positions.contains(side)) {
                Functions.getConnectedBlocks(of, (Direction[])ArrayUtils.removeElement((Object[])Direction.values(), (Object)checkedSide.func_176734_d()), side, world, positions, limit);
                continue;
            }
            positions.add(side);
            if (positions.size() < limit) continue;
            return positions;
        }
        return positions;
    }

    public static boolean isEmpty(Collection<ItemStack> itemStackCollection) {
        for (ItemStack itemStack : itemStackCollection) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerInSurvival(PlayerEntity player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }

    public static boolean isSuperClass(Class<?> subject, Object of) {
        if (of.getClass() == Class.class) {
            return subject.isAssignableFrom((Class)of);
        }
        return subject.isInstance(of);
    }

    public static List<BlockPos> boundingBoxToPositions(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (double X = axisAlignedBB.field_72340_a; X <= axisAlignedBB.field_72336_d; X += 1.0) {
            for (double Y = axisAlignedBB.field_72338_b; Y <= axisAlignedBB.field_72337_e; Y += 1.0) {
                for (double Z = axisAlignedBB.field_72339_c; Z <= axisAlignedBB.field_72334_f; Z += 1.0) {
                    positions.add(new BlockPos(X, Y, Z));
                }
            }
        }
        return positions;
    }

    public static Direction randomHorizontalFacing() {
        return Constants.HORIZONTALS[Methods.RANDOMGENERATOR.nextInt(Constants.HORIZONTALS.length)];
    }

    public static Item registerBlockItem(Block block, String ID, String identifier, RegistryEvent.Register<Item> registryEvent, Item.Properties properties) {
        Item b1 = (Item)new BlockItem(block, properties).setRegistryName(ID, identifier);
        registryEvent.getRegistry().register((IForgeRegistryEntry)b1);
        return b1;
    }

    public static boolean canReplaceBlock(BlockPos blockPos, World world) {
        BlockState iBlockState = world.func_180495_p(blockPos);
        if (world.func_175625_s(blockPos) != null) {
            return false;
        }
        return iBlockState.func_185887_b((IBlockReader)world, blockPos) != -1.0f;
    }

    public static ItemEntity spawnItemInWorld(ItemStack itemStack, World world, BlockPos pos) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Don't spawn items in client world");
        }
        ItemEntity entityItem = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, itemStack);
        world.func_217376_c((Entity)entityItem);
        entityItem.func_213293_j(0.0, 0.0, 0.0);
        return entityItem;
    }

    public static BlockPos getPosAboveSolidBlock(World world, BlockPos blockPos) {
        blockPos = blockPos.func_177981_b(world.func_234938_ad_());
        BlockState blockState = world.func_180495_p(blockPos);
        while (blockState.func_185904_a().func_76222_j() || blockState.func_185904_a() == Material.field_151584_j) {
            blockPos = blockPos.func_177977_b();
            blockState = world.func_180495_p(blockPos);
        }
        blockPos = blockPos.func_177984_a();
        return blockPos;
    }

    public static Item registerItem(Item item, String mod, String ID, RegistryEvent.Register<Item> registryEvent) {
        item.setRegistryName(mod, ID);
        registryEvent.getRegistry().register((IForgeRegistryEntry)item);
        return item;
    }

    public static ArrayList<Direction> getSideDirections(Direction of) {
        ArrayList<Direction> sidedirections = new ArrayList<Direction>(5);
        switch (of) {
            case DOWN: {
                Collections.addAll(sidedirections, Direction.UP, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case UP: {
                Collections.addAll(sidedirections, Direction.DOWN, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case EAST: {
                Collections.addAll(sidedirections, Direction.WEST, Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case WEST: {
                Collections.addAll(sidedirections, Direction.EAST, Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH);
                break;
            }
            case SOUTH: {
                Collections.addAll(sidedirections, Direction.NORTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST);
                break;
            }
            case NORTH: {
                Collections.addAll(sidedirections, Direction.SOUTH, Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST);
            }
        }
        return sidedirections;
    }

    public static boolean areItemTypesEqual(ItemStack one, ItemStack two) {
        if (!one.func_190926_b() && !two.func_190926_b()) {
            Item secondItem;
            Item oneItem = one.func_77973_b();
            return oneItem == (secondItem = two.func_77973_b()) && one.func_77952_i() == two.func_77952_i() && oneItem.getRegistryName().equals((Object)secondItem.getRegistryName()) && ItemStack.func_77970_a((ItemStack)one, (ItemStack)two);
        }
        return false;
    }

    public static boolean areItemsEqualInDictionary(ItemStack one, ItemStack two) {
        if (!one.func_190926_b() && !two.func_190926_b()) {
            Collection identifiers = ItemTags.func_199903_a().func_199913_a((Object)one.func_77973_b());
            Collection identifiers2 = ItemTags.func_199903_a().func_199913_a((Object)two.func_77973_b());
            for (ResourceLocation identifier : identifiers) {
                if (!identifiers2.contains(identifier)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFuelValue(@Nonnull ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack);
    }

    public static Direction isBlockDirectlyPowered(World worldIn, BlockPos pos) {
        for (Direction from : Direction.values()) {
            int p;
            BlockPos sidepos = pos.func_177972_a(from);
            BlockState sidestate = worldIn.func_180495_p(sidepos);
            Block sideblock = sidestate.func_177230_c();
            if (!sideblock.func_149744_f(sidestate) || (p = sidestate.func_185893_b((IBlockReader)worldIn, sidepos, from)) <= 0) continue;
            return from;
        }
        return null;
    }

    public static Direction isPoweredExceptSide(Direction side, World world, BlockPos position) {
        for (Direction facing : Direction.values()) {
            int p;
            BlockPos sidepos;
            BlockState sidestate;
            Block sideblock;
            if (side == facing || !(sideblock = (sidestate = world.func_180495_p(sidepos = position.func_177972_a(facing))).func_177230_c()).func_149744_f(sidestate) || (p = sidestate.func_185893_b((IBlockReader)world, sidepos, facing)) <= 0) continue;
            return facing;
        }
        return null;
    }

    public static int calculateStringWidth(ITextComponent string) {
        if (string != null) {
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(string.getString());
        }
        return 0;
    }

    public static int calculateLongestStringWidth(Collection<ITextComponent> objects) {
        int width = 0;
        for (ITextComponent s : objects) {
            int nextwidth = Functions.calculateStringWidth(s);
            if (nextwidth <= width) continue;
            width = nextwidth;
        }
        return width;
    }

    @Deprecated
    public static String getTranslation(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static String getBlockName(BlockState blockState) {
        if (blockState.func_177230_c() instanceof AirBlock) {
            return "Air";
        }
        ItemStack itemStack = new ItemStack((IItemProvider)blockState.func_177230_c(), 1);
        if (!itemStack.func_190926_b()) {
            return itemStack.func_151000_E().getString();
        }
        return blockState.func_177230_c().func_149739_a();
    }

    public static boolean removeHeldItem(PlayerEntity player, Item item) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == item) {
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            return true;
        }
        if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == item) {
            player.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    public static ItemStack getStackFromBlockState(BlockState blockState) {
        Item b;
        ItemStack ds = new ItemStack((IItemProvider)blockState.func_177230_c(), 1);
        if (ds.func_190926_b() && !((b = Item.func_150898_a((Block)blockState.func_177230_c())) instanceof AirItem)) {
            ds = new ItemStack((IItemProvider)b);
        }
        return ds;
    }

    public static Field getSecureField(Class owner, int number) {
        Field[] fields = owner.getDeclaredFields();
        if (number < fields.length) {
            Field f = fields[number];
            if (f.getType() != owner.getEnclosingClass()) {
                f.setAccessible(true);
                return f;
            }
            return Functions.getSecureField(owner.getSuperclass(), number);
        }
        return null;
    }

    public static boolean isObfuscatedEnvironment() {
        return false;
    }

    public static Field getSecureField(Class<?> owningClass, String field) {
        Field f = null;
        try {
            f = owningClass.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            if (owningClass.getSuperclass() != null) {
                return Functions.getSecureField(owningClass.getSuperclass(), field);
            }
            System.err.println("Searched all super classes - field " + field + " not found");
        }
        return f;
    }

    public static Method getAnyMethod(Class<?> owner, String name, Class<?> ... parameterTypes) {
        Method m = null;
        try {
            m = owner.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Field getPublicField(Class<?> owner, String fieldName) {
        Field f = null;
        try {
            f = owner.getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return f;
    }

    public static ItemStack tryExtractItems(IItemHandler itemHandler, ItemStack itemStack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack presentstack = itemHandler.getStackInSlot(slot);
            if (!Functions.areItemTypesEqual(itemStack, presentstack)) continue;
            return itemHandler.extractItem(slot, itemStack.func_190916_E(), simulate);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemHandler copyStacks(IItemHandler from) {
        ItemHandler itemHandler = new ItemHandler(from.getSlots());
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack stack = from.extractItem(i, 64, true);
            if (stack.func_190926_b() || Functions.tryInsertItem((IItemHandler)itemHandler, stack.func_77946_l())) continue;
            System.out.println("Couldn't insert " + stack);
            return itemHandler;
        }
        return itemHandler;
    }

    public static boolean tryInsertItem(IItemHandler iItemHandler, ItemStack itemStack) {
        ItemStack out = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)itemStack.func_77946_l(), (boolean)false);
        itemStack.func_190920_e(out.func_190916_E());
        return out.func_190926_b();
    }

    public static boolean canInsertItem(IItemHandler into, ItemStack stack) {
        int i;
        if (stack.func_190926_b()) {
            return false;
        }
        int slots = into.getSlots();
        for (i = 0; i < slots; ++i) {
            ItemStack result;
            ItemStack pressent = into.getStackInSlot(i);
            if (!into.isItemValid(i, stack) || !Functions.areItemTypesEqual(stack, pressent) || !(result = into.insertItem(i, stack, true)).func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < slots; ++i) {
            ItemStack rem;
            ItemStack next = into.getStackInSlot(i);
            if (!next.func_190926_b() || !into.isItemValid(i, stack) || !(rem = into.insertItem(i, stack, true)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isHolding(Predicate<Item> itemPredicate, LivingEntity entity) {
        return itemPredicate.test(entity.func_184614_ca().func_77973_b()) || itemPredicate.test(entity.func_184592_cb().func_77973_b());
    }

    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int ticksToMinutes(int ticks) {
        return Functions.ticksToSeconds(ticks) / 60;
    }

    public static int ticksToHours(int ticks) {
        return Functions.ticksToMinutes(ticks) / 60;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Functions.secondsToTicks(minutes) * 60;
    }

    public static int hoursToTicks(int hours) {
        return Functions.minutesToTicks(hours) * 60;
    }

    public static ItemStack getHeldItem(PlayerEntity playerEntity, Item item) {
        if (playerEntity.func_184614_ca().func_77973_b() == item) {
            return playerEntity.func_184614_ca();
        }
        if (playerEntity.func_184592_cb().func_77973_b() == item) {
            return playerEntity.func_184592_cb();
        }
        return null;
    }

    public static ItemStack getHeldItem(PlayerInventory playerInventory, Item item) {
        return Functions.getHeldItem(playerInventory.field_70458_d, item);
    }

    public static Hand getHandHoldingItem(PlayerEntity playerEntity, Item item) {
        if (playerEntity.func_184614_ca().func_77973_b() == item) {
            return Hand.MAIN_HAND;
        }
        if (playerEntity.func_184592_cb().func_77973_b() == item) {
            return Hand.OFF_HAND;
        }
        return null;
    }

    public static int findItemIn(IItemHandler itemHandler, ItemStack stack) {
        int size = itemHandler.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack nextstack = itemHandler.getStackInSlot(slot);
            if (!Functions.areItemTypesEqual(nextstack, stack)) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack searchItem(IItemHandler in, Item forItem) {
        for (int i = 0; i < in.getSlots(); ++i) {
            ItemStack itemStack = in.getStackInSlot(i);
            if (itemStack.func_77973_b() != forItem) continue;
            return itemStack;
        }
        return null;
    }

    public static boolean removeBlock(BlockPos position, IWorld world) {
        return world.func_217377_a(position, false);
    }

    public static Rotation directionToRotation(Direction direction) {
        Rotation rotation;
        assert (direction.func_176740_k().func_176722_c());
        switch (direction) {
            case NORTH: {
                rotation = Rotation.NONE;
                break;
            }
            case SOUTH: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case EAST: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case WEST: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            default: {
                return null;
            }
        }
        return rotation.func_185830_a(Rotation.COUNTERCLOCKWISE_90);
    }

    public static PacketBuffer emptyBuffer() {
        return new PacketBuffer(Unpooled.buffer());
    }
}

