/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemHandler
extends ItemStackHandler {
    private TileEntity owner;

    public ItemHandler(int size) {
        super(size);
    }

    public ItemHandler(int size, @Nullable TileEntity tileEntity) {
        this(size);
        this.owner = tileEntity;
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public ItemHandler(NonNullList<ItemStack> itemStacks) {
        super(itemStacks);
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.setStackInSlot(slot, copy);
                    this.onContentsChanged(slot);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.setStackInSlot(slot, copy);
                this.onContentsChanged(slot);
            } else {
                stack.func_190918_g(m);
            }
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setStackInSlot(slot, stack.func_77979_a(m));
                this.onContentsChanged(slot);
            } else {
                stack.func_190918_g(m);
            }
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
            this.onContentsChanged(slot);
        }
        return ItemStack.field_190927_a;
    }

    public TileEntity getOwner() {
        return this.owner;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected void onContentsChanged(int slot) {
        if (this.owner != null) {
            this.owner.func_70296_d();
        }
    }
}

