/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import dev.buildtool.satako.BlockData;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.Options;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

public final class Methods {
    public static final Random RANDOMGENERATOR = new Random();

    public static void setBlocks(BlockPos from, BlockPos to, BlockState state, World world) {
        Stream poss = BlockPos.func_218281_b((BlockPos)from, (BlockPos)to);
        poss.forEach(blockPos -> world.func_175656_a(blockPos, state));
    }

    public static void drawSingleBlockSelection(PlayerEntity player, float partialTicks, BlockState blockState, BlockPos pos) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        GlStateManager.func_227701_d_((float)2.0f);
        GlStateManager.func_227621_I_();
        GlStateManager.func_227667_a_((boolean)false);
        GlStateManager.func_227667_a_((boolean)true);
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
    }

    public static void drawBlockSelection(PlayerEntity player, float partialTicks, BlockPos start, BlockPos end) {
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(start, end);
        for (double X = axisAlignedBB.field_72340_a; X <= axisAlignedBB.field_72336_d; X += 1.0) {
            for (double Y = axisAlignedBB.field_72338_b; Y <= axisAlignedBB.field_72337_e; Y += 1.0) {
                for (double Z = axisAlignedBB.field_72339_c; Z <= axisAlignedBB.field_72334_f; Z += 1.0) {
                    BlockPos nextpos = new BlockPos(X, Y, Z);
                    BlockState blockState = player.field_70170_p.func_180495_p(nextpos);
                    GlStateManager.func_227740_m_();
                    GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
                    GlStateManager.func_227701_d_((float)2.0f);
                    GlStateManager.func_227621_I_();
                    GlStateManager.func_227667_a_((boolean)false);
                    GlStateManager.func_227667_a_((boolean)true);
                    GlStateManager.func_227619_H_();
                    GlStateManager.func_227737_l_();
                }
            }
        }
    }

    public static void removeTileEntitySilently(BlockPos pos, World world) {
        TileEntity tileentity = world.func_175625_s(pos);
        try {
            Field processingLoadedTiles = Functions.isObfuscatedEnvironment() ? Functions.getSecureField(World.class, Options.processingLoadedTiles) : Functions.getSecureField(world.getClass(), "updatingBlockEntities");
            Field addedTileEntityList = Functions.isObfuscatedEnvironment() ? Functions.getSecureField(World.class, Options.addedTileEntityList) : Functions.getSecureField(world.getClass(), "pendingBlockEntities");
            List atl = (List)addedTileEntityList.get(world);
            if (tileentity != null && processingLoadedTiles.getBoolean(world)) {
                tileentity.func_145843_s();
                atl.remove(tileentity);
                world.field_147482_g.remove(tileentity);
            } else {
                if (tileentity != null) {
                    atl.remove(tileentity);
                    world.field_147482_g.remove(tileentity);
                    world.field_175730_i.remove(tileentity);
                }
                Chunk chunk = (Chunk)world.func_217349_x(pos);
                chunk.func_177434_r().remove(pos);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void drawCircle(Tessellator tessellator) {
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        int num_segments = 16;
        float radius = 0.7f;
        for (int ii = 0; ii < num_segments; ++ii) {
            float theta = 6.283185f * (float)ii / (float)num_segments;
            float xx = radius * MathHelper.func_76134_b((float)theta);
            float yy = radius * MathHelper.func_76126_a((float)theta);
            bufferbuilder.func_225582_a_((double)xx, (double)yy, 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    private static void drawFilledCircle(Tessellator tessellator, float radius, Color color) {
        int circle_points = 50;
        float angle = 6.2832f / (float)circle_points;
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(9, DefaultVertexFormats.field_181706_f);
        double angle1 = 0.0;
        double xx = (double)radius * Math.cos(0.0);
        double yy = (double)radius * Math.sin(0.0);
        bufferBuilder.func_225582_a_(xx, yy, 0.0).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
        for (int i = 0; i < circle_points; ++i) {
            bufferBuilder.func_225582_a_((double)radius * Math.cos(angle1), (double)radius * Math.sin(angle1), 0.0).func_225586_a_(0, 0, 0, 255).func_181675_d();
            angle1 += (double)angle;
        }
        tessellator.func_78381_a();
    }

    public static void setTileEntitySilently(World world, BlockData blockData) {
        BlockPos pos = blockData.position.func_185334_h();
        TileEntity tileEntityIn = blockData.tile;
        if (tileEntityIn != null) {
            try {
                Field processingLoadedTiles = Functions.isObfuscatedEnvironment() ? Functions.getSecureField(World.class, Options.processingLoadedTiles) : Functions.getSecureField(World.class, "updatingBlockEntities");
                boolean iplt = processingLoadedTiles.getBoolean(world);
                List addedTileEntityList = Functions.isObfuscatedEnvironment() ? (List)Functions.getSecureField(World.class, Options.addedTileEntityList).get(world) : (List)Functions.getSecureField(World.class, "pendingBlockEntities").get(world);
                if (iplt) {
                    if (tileEntityIn.func_145831_w() != world) {
                        tileEntityIn.func_226984_a_(world, pos);
                    }
                    addedTileEntityList.removeIf(tileentity -> tileentity.func_174877_v().equals((Object)pos));
                    addedTileEntityList.add(tileEntityIn);
                } else {
                    List dest = iplt ? addedTileEntityList : world.field_147482_g;
                    boolean flag = dest.add(tileEntityIn);
                    if (flag && tileEntityIn instanceof ITickable) {
                        world.field_175730_i.add(tileEntityIn);
                    }
                    Chunk chunk = (Chunk)world.func_217349_x(pos);
                    tileEntityIn.func_226984_a_(world, pos);
                    tileEntityIn.func_174878_a(pos);
                    chunk.func_177434_r().put(pos, tileEntityIn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean setBlockStateSilently(World world, BlockPos targetPos, BlockState newState) {
        return false;
    }

    public static void drawStringWithBackground(MatrixStack matrixStack, Object obj, int x, int y, IntegerColor background) {
        String string = obj.toString();
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, string, (float)(x + 2), (float)(y + 4), background.getIntColor());
    }

    public static void sendBlockUpdate(ServerWorld worldServer, BlockPos blockPos) {
        BlockState blockState = worldServer.func_180495_p(blockPos);
        worldServer.func_184138_a(blockPos, blockState, blockState, 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openClientGui(World world, Screen screen) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a(screen);
        }
    }

    public static void playSound(World world, BlockPos blockPos, SoundEvent sound, float volume, float pitch) {
        world.func_184134_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), sound, null, volume, pitch, false);
    }

    public static void drawVerticalLine(int x, int startY, int endY, IntegerColor color, int thickness) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GL11.glLineWidth((float)thickness);
        bufferBuilder.func_225582_a_((double)x, (double)startY, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_225582_a_((double)x, (double)endY, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawHorizontalLine(int startX, int endX, int y, IntegerColor color, int thickness) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GL11.glLineWidth((float)thickness);
        bufferBuilder.func_225582_a_((double)startX, (double)y, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        bufferBuilder.func_225582_a_((double)endX, (double)y, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void sendMessageToPlayer(PlayerEntity player, String message) {
        player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
    }

    public static void drawCenteredString(MatrixStack matrixStack, ITextComponent o, int X, int Y, IntegerColor color) {
        Methods.drawString(matrixStack, o, X - Functions.calculateStringWidth(o) / 2, Y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, ITextComponent o, int X, int Y, IntegerColor color) {
        Methods.drawStringWithShadow(matrixStack, o, X - Functions.calculateStringWidth(o) / 2, Y, color);
    }

    public static void drawString(MatrixStack matrixStack, Object o, int X, int Y, IntegerColor color) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, o.toString(), (float)X, (float)Y, color.getIntColor());
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, Object o, int X, int Y, IntegerColor color) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, o.toString(), (float)X, (float)Y, color.getIntColor());
    }

    public static void show(Object[] objects) {
        System.out.println(Arrays.toString(objects));
    }

    public static void addPotionEffectNoParticles(LivingEntity entityLivingBase, Effect potion, int duration, int strength) {
        entityLivingBase.func_195064_c(new EffectInstance(potion, duration, strength, false, false));
    }
}

