/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.debugging.Analyzer;
import dev.buildtool.satako.debugging.EventListener;
import dev.buildtool.satako.packets.SendItemNBT;
import dev.buildtool.satako.packets.SendSound;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="satako")
public class Satako {
    public static final String ID = "satako";
    public static SimpleChannel CHANNEL;
    public static ForgeConfigSpec.BooleanValue DO_DEBUG;

    public Satako() {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(ID, "first"), () -> "1.0", s -> true, s -> true);
        CHANNEL.messageBuilder(SendItemNBT.class, 0).encoder((sendItemNBT, packetBuffer) -> {
            packetBuffer.func_150786_a(sendItemNBT.compoundNBT);
            packetBuffer.func_179249_a((Enum)sendItemNBT.toHand);
        }).decoder(packetBuffer -> new SendItemNBT(packetBuffer.func_150793_b(), (Hand)packetBuffer.func_179257_a(Hand.class))).consumer((sendItemNBT, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                context.enqueueWork(() -> context.getSender().func_184586_b(sendItemNBT.toHand).func_77982_d(sendItemNBT.compoundNBT));
            } else {
                context.enqueueWork(() -> {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    ItemStack heldItem = minecraft.field_71439_g.func_184586_b(sendItemNBT.toHand);
                    heldItem.func_77982_d(sendItemNBT.compoundNBT);
                });
            }
            context.setPacketHandled(true);
        }).add();
        CHANNEL.messageBuilder(SendSound.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder((sendSound, buffer) -> {
            buffer.writeFloat(sendSound.pitch);
            buffer.writeFloat(sendSound.volume);
            buffer.func_180714_a(sendSound.soundEvent.getRegistryName().toString());
        }).decoder(buffer -> new SendSound(buffer.readFloat(), buffer.readFloat(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(buffer.func_218666_n())))).consumer((sendSound, contextSupplier) -> {
            ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(() -> Minecraft.func_71410_x().field_71439_g.func_184185_a(sendSound.soundEvent, sendSound.volume, sendSound.pitch));
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        }).add();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
            DO_DEBUG = builder.define("Enable extra debugging info", true);
            return builder.build();
        }).getRight());
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (((Boolean)DO_DEBUG.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register(EventListener.class);
            eventBus.register(Analyzer.class);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    PrintWriter printWriter = new PrintWriter(new File("logs", "general.log"));
                    ModList.get().forEachModContainer((s, modContainer) -> {
                        if (!s.equals("minecraft") && !s.equals("forge")) {
                            printWriter.println("Next mod: " + s);
                            IModInfo iModInfo = modContainer.getModInfo();
                            iModInfo.getDependencies().forEach(modVersion -> printWriter.println("depends " + (modVersion.isMandatory() ? "obligatory" : "optionally") + " on " + modVersion.getModId()));
                        }
                    });
                    printWriter.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }));
        }
    }
}

