/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.gui;

import dev.buildtool.satako.Functions;
import dev.buildtool.satako.gui.Hideable;
import dev.buildtool.satako.gui.Positionable;
import dev.buildtool.satako.gui.Scrollable;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class BetterButton
extends ExtendedButton
implements Scrollable,
Positionable,
Hideable {
    public String string;
    public boolean verticalScroll;
    public boolean horizontalScroll;
    public int scrollingAmount;
    protected FontRenderer fontRenderer;

    public BetterButton(int x, int y, int width, int height, ITextComponent text, Button.IPressable pressable) {
        super(x, y, width, height, text, pressable);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.scrollingAmount = this.field_230689_k_;
        this.string = text.getString();
    }

    public BetterButton(int x, int y, ITextComponent text) {
        this(x, y, Minecraft.func_71410_x().field_71466_p.func_78256_a(text.getString()) + 8, 20, text, p_onPress_1_ -> {});
        this.string = text.getString();
    }

    public BetterButton(int x, int y, ITextComponent text, Button.IPressable onPress) {
        this(x, y, Minecraft.func_71410_x().field_71466_p.func_78256_a(text.getString()) + 8, 20, text, onPress);
    }

    public BetterButton(int x, int y, ITextComponent text, boolean verticalScroll_, boolean horizontalScroll_) {
        this(x, y, text);
        this.verticalScroll = verticalScroll_;
        this.horizontalScroll = horizontalScroll_;
    }

    public static BetterButton createPositionlessButton(ITextComponent caption) {
        return new BetterButton(0, 0, caption);
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (vertical && this.verticalScroll) {
            this.field_230691_m_ = (int)((float)this.field_230691_m_ + Math.signum(amount) * (float)this.scrollingAmount);
        } else if (!vertical && this.horizontalScroll) {
            this.field_230690_l_ += amount;
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
        if (b) {
            if (vertical) {
                this.verticalScroll = true;
            } else {
                this.horizontalScroll = true;
            }
        } else if (vertical) {
            this.verticalScroll = false;
        } else {
            this.horizontalScroll = false;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.field_230693_o_;
    }

    @Override
    public void setEnabled() {
        this.field_230693_o_ = true;
    }

    @Override
    public void setDisabled() {
        this.field_230693_o_ = false;
    }

    @Override
    public void setScrollAmount(int pixels) {
        this.scrollingAmount = pixels;
    }

    public int func_230998_h_() {
        return this.field_230688_j_;
    }

    public int func_238483_d_() {
        return this.field_230689_k_;
    }

    @Override
    public int getX() {
        return this.field_230690_l_;
    }

    @Override
    public void setX(int X) {
        this.field_230690_l_ = X;
    }

    @Override
    public int getY() {
        return this.field_230691_m_;
    }

    @Override
    public void setY(int Y) {
        this.field_230691_m_ = Y;
    }

    @Override
    public void setHidden() {
        this.field_230694_p_ = false;
    }

    @Override
    public void setVisible() {
        this.field_230694_p_ = true;
    }

    public void setClickHandler(Button.IPressable handler) {
        Field field = Functions.getSecureField(Button.class, 0);
        if (field != null && field.getType() == Button.IPressable.class) {
            try {
                field.set(this, handler);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

