/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.gui;

import com.google.common.collect.TreeBasedTable;
import dev.buildtool.satako.gui.ControlsContainer;
import dev.buildtool.satako.gui.Label;
import dev.buildtool.satako.gui.Positionable;
import dev.buildtool.satako.gui.TextField;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;

public class GuiElements {
    private Screen owner;
    private TreeBasedTable<Integer, Integer, Object> elementmap = TreeBasedTable.create();
    private HashMap<Integer, Integer> rowHeights = new HashMap();
    private HashMap<Integer, Integer> columnWidths = new HashMap();
    private int spacing;

    public GuiElements(Screen screen, int elementSpacing) {
        this.owner = screen;
        this.spacing = elementSpacing;
    }

    public GuiElements(Screen screen) {
        this.owner = screen;
        this.spacing = 3;
    }

    public void addElement(int row, int column, Object object) {
        this.addElement(row, column, object, 0, 0);
    }

    public void addElement(int row, int column, Object object, int offsetX, int offsetY) {
        if (this.owner instanceof ControlsContainer && object instanceof Positionable) {
            Positionable positionable = (Positionable)object;
            Object ob = this.elementmap.get((Object)row, (Object)(column - 1));
            if (ob instanceof Positionable) {
                Positionable previouselement = (Positionable)ob;
                positionable.setX(this.spacing + previouselement.getX() + previouselement.getWidth() + offsetX);
            } else {
                positionable.setX(this.spacing + offsetX);
            }
            SortedMap previousrow = this.elementmap.row((Object)(row - 1));
            if (previousrow != null) {
                int y = 0;
                for (int i = 0; i < previousrow.size(); ++i) {
                    Positionable positionable1;
                    Object objj = previousrow.get(i);
                    if (!(objj instanceof Positionable) || y >= (positionable1 = (Positionable)objj).getY() + positionable1.getHeight()) continue;
                    y = positionable1.getY() + positionable1.getHeight();
                }
                positionable.setY(this.spacing + y + offsetY);
            } else {
                positionable.setY(this.spacing + offsetY);
            }
            if (positionable instanceof Label) {
                ((ControlsContainer)this.owner).addLabel((Label)((Object)positionable));
            } else if (positionable instanceof TextField) {
                ((ControlsContainer)this.owner).addTextField((TextField)positionable);
            } else if (positionable instanceof Button) {
                ((ControlsContainer)this.owner).addButton((Button)positionable);
            }
        }
        this.elementmap.put((Object)row, (Object)column, object);
    }

    public void alignColumns() {
        Map columns = this.elementmap.columnMap();
        for (Integer column : columns.keySet()) {
            int broadest = 0;
            Map row = (Map)columns.get(column);
            for (Integer key : row.keySet()) {
                Positionable positionable;
                int width;
                Object value = row.get(key);
                if (!(value instanceof Positionable) || (width = (positionable = (Positionable)value).getWidth()) <= broadest) continue;
                broadest = width;
            }
            this.columnWidths.put(column, broadest);
        }
        this.columnWidths.forEach((nextcolumn, integer2) -> {
            Map nextColumn = (Map)columns.get(nextcolumn + 1);
            if (nextColumn != null) {
                for (Object o : nextColumn.values()) {
                    if (!(o instanceof Positionable)) continue;
                    ((Positionable)o).setX(this.columnWidths.get(nextcolumn) + this.spacing);
                }
            }
        });
    }

    public Object getElement(int row, int column) {
        return this.elementmap.get((Object)row, (Object)column);
    }

    public void removeElement(int row, int column) {
        Object o = this.elementmap.remove((Object)row, (Object)column);
        if (this.owner instanceof ControlsContainer) {
            ControlsContainer controlsContainer = (ControlsContainer)this.owner;
            if (o instanceof TextField) {
                controlsContainer.removeTextField((TextField)o);
            } else if (o instanceof Label) {
                controlsContainer.removeLabel((Label)o);
            } else if (o instanceof Button) {
                controlsContainer.removeButton((Button)o);
            }
        }
    }

    public void removeElement(Object o) {
        SortedSet rowKeys = this.elementmap.rowKeySet();
        Set columnkeys = this.elementmap.columnKeySet();
        block0: for (Integer rowKey : rowKeys) {
            for (Integer columnkey : columnkeys) {
                Object value = this.elementmap.get((Object)rowKey, (Object)columnkey);
                if (value == null || value != o) continue;
                this.elementmap.remove((Object)rowKey, (Object)columnkey);
                break block0;
            }
        }
    }

    public void clearElements() {
        this.elementmap.clear();
        this.rowHeights.clear();
        this.columnWidths.clear();
    }

    public String toString() {
        return this.elementmap.toString();
    }
}

