/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.FollowOwnerGoal;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.registers.Sounds;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class Drone
extends Turret {
    private static final EntityDataAccessor<Boolean> FOLLOWING_OWNER = SynchedEntityData.m_135353_(Drone.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Drone(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_CACTUS, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
    }

    @Override
    protected InteractionResult m_6071_(Player playerEntity, InteractionHand interactionHand) {
        ItemStack itemInHand = playerEntity.m_21120_(interactionHand);
        if (this.m_21223_() < this.m_21233_() && itemInHand.m_204131_().anyMatch(itemTagKey -> itemTagKey.f_203868_().equals((Object)KTurrets.STEEL_INGOT))) {
            this.m_5634_(this.m_21233_() / 4.0f);
            itemInHand.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.canUse(playerEntity)) {
            if (this.f_19853_.f_46443_) {
                this.openTargetScreen();
            }
            return InteractionResult.SUCCESS;
        }
        if (this.f_19853_.f_46443_) {
            playerEntity.m_6352_((Component)new TextComponent("k-turrets.drone.not.yours"), Util.f_137441_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_142535_(float p_147105_, float p_147106_, DamageSource p_147107_) {
        return false;
    }

    protected void m_7840_(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    public void m_7023_(Vec3 vector) {
        float flyingSpeed = this.m_6113_();
        if (this.m_20069_()) {
            this.m_19920_(flyingSpeed / 2.0f, vector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
        } else if (this.m_20077_()) {
            this.m_19920_(flyingSpeed / 2.0f, vector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
        } else {
            BlockPos ground = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
            float f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            float f1 = (float)(this.m_21133_(Attributes.f_22279_) / (double)(f * f * f));
            f = 0.91f;
            if (this.f_19861_) {
                f = this.f_19853_.m_8055_(ground).getFriction((LevelReader)this.f_19853_, ground, (Entity)this) * 0.91f;
            }
            this.m_19920_(this.f_19861_ ? 0.1f * f1 : flyingSpeed, vector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)f));
        }
        this.m_21043_((LivingEntity)this, false);
    }

    public boolean m_6147_() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FOLLOWING_OWNER, (Object)true);
        this.f_19804_.m_135381_(MOVEABLE, (Object)true);
    }

    public boolean isFollowingOwner() {
        return (Boolean)this.f_19804_.m_135370_(FOLLOWING_OWNER);
    }

    public void followOwner(boolean follow) {
        this.f_19804_.m_135381_(FOLLOWING_OWNER, (Object)follow);
    }

    @Override
    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128379_("Following", this.isFollowingOwner());
    }

    @Override
    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.followOwner(compoundNBT.m_128471_("Following"));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal(this));
    }

    protected PathNavigation m_6037_(Level p_21480_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_21480_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return this.m_20206_() * 0.4f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (Boolean)KTurrets.ENABLE_DRONE_SOUND.get() != false ? (SoundEvent)Sounds.DRONE_FLY.get() : null;
    }

    public int m_8100_() {
        return 330;
    }

    @Override
    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.getOwner().ifPresent(uuid1 -> {
            Player player;
            if (!this.f_19853_.f_46443_ && (player = this.f_19853_.m_46003_(uuid1)) != null) {
                player.m_6352_((Component)new TranslatableComponent("k_turrets.drone.destroyed", new Object[]{this.m_5446_()}), this.m_142081_());
            }
        });
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }
}

