/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.packets.ClaimTurret;
import dev.buildtool.kturrets.packets.DismantleTurret;
import dev.buildtool.kturrets.packets.ToggleDroneFollow;
import dev.buildtool.kturrets.packets.ToggleMobility;
import dev.buildtool.kturrets.packets.TogglePlayerProtection;
import dev.buildtool.kturrets.packets.TurretTargets;
import dev.buildtool.kturrets.registers.Sounds;
import dev.buildtool.kturrets.registers.TContainers;
import dev.buildtool.kturrets.registers.TEntities;
import dev.buildtool.kturrets.registers.TItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="k_turrets")
public class KTurrets {
    public static final String ID = "k_turrets";
    public static final ResourceLocation STEEL_INGOT = new ResourceLocation("forge", "ingots/steel");
    private static final String NP = "1.0";
    public static SimpleChannel channel;
    public static ForgeConfigSpec.DoubleValue ARROW_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue ARROW_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue ARROW_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue ARROW_TURRET_DAMAGE;
    public static ForgeConfigSpec.IntValue ARROW_TURRET_RATE;
    public static ForgeConfigSpec.IntValue BULLET_TURRET_RATE;
    public static ForgeConfigSpec.IntValue CHARGE_TURRET_RATE;
    public static ForgeConfigSpec.DoubleValue BULLET_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue BULLET_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue BULLET_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue GOLD_BULLET_DAMAGE;
    public static ForgeConfigSpec.IntValue IRON_BULLET_DAMAGE;
    public static ForgeConfigSpec.DoubleValue CHARGE_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue CHARGE_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue CHARGE_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue CHARGE_TURRET_DAMAGE;
    public static ForgeConfigSpec.DoubleValue BRICK_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue BRICK_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue BRICK_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue BRICK_DAMAGE;
    public static ForgeConfigSpec.IntValue NETHERBRICK_DAMAGE;
    public static ForgeConfigSpec.IntValue BRICK_TURRET_RATE;
    public static ForgeConfigSpec.DoubleValue GAUSS_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue GAUSS_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue GAUSS_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue GAUSS_TURRET_DAMAGE;
    public static ForgeConfigSpec.IntValue GAUSS_TURRET_RATE;
    public static ForgeConfigSpec.DoubleValue COBBLE_TURRET_HEALTH;
    public static ForgeConfigSpec.DoubleValue COBBLE_TURRET_RANGE;
    public static ForgeConfigSpec.DoubleValue COBBLE_TURRET_ARMOR;
    public static ForgeConfigSpec.IntValue COBBLE_TURRET_DAMAGE;
    public static ForgeConfigSpec.IntValue COBBLE_TURRET_RATE;
    public static ForgeConfigSpec.BooleanValue ENABLE_DRONE_SOUND;

    public KTurrets() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TEntities.ENTITIES.register(eventBus);
        TItems.ITEMS.register(eventBus);
        TContainers.CONTAINERS.register(eventBus);
        Sounds.SOUNDS.register(eventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
            builder.push("Arrow turret");
            ARROW_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, 500.0);
            ARROW_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 100.0);
            ARROW_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            ARROW_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 10, 60);
            ARROW_TURRET_DAMAGE = builder.defineInRange("Base damage", 6, 1, 100);
            builder.pop();
            builder.push("Bullet turret");
            BULLET_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, 500.0);
            BULLET_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 100.0);
            BULLET_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            BULLET_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 10, 60);
            IRON_BULLET_DAMAGE = builder.defineInRange("Iron bullet damage", 8, 1, 100);
            GOLD_BULLET_DAMAGE = builder.defineInRange("Gold bullet damage", 7, 1, 100);
            builder.pop();
            builder.push("Fire charge turret");
            CHARGE_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, 500.0);
            CHARGE_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 100.0);
            CHARGE_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            CHARGE_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 10, 60);
            CHARGE_TURRET_DAMAGE = builder.defineInRange("Damage", 6, 1, 100);
            builder.pop();
            builder.push("Brick turret");
            BRICK_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, 500.0);
            BRICK_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 100.0);
            BRICK_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            BRICK_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 10, 60);
            BRICK_DAMAGE = builder.defineInRange("Brick damage", 9, 1, 100);
            NETHERBRICK_DAMAGE = builder.defineInRange("Nether brick damage", 10, 1, 100);
            builder.pop();
            builder.push("Gauss turret");
            GAUSS_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, 500.0);
            GAUSS_TURRET_RANGE = builder.defineInRange("Range", 32.0, 8.0, 100.0);
            GAUSS_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            GAUSS_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 10, 60);
            GAUSS_TURRET_DAMAGE = builder.defineInRange("Damage", 12, 1, 100);
            builder.pop();
            builder.push("Cobble turret");
            COBBLE_TURRET_HEALTH = builder.defineInRange("Health", 60.0, 10.0, 500.0);
            COBBLE_TURRET_RANGE = builder.defineInRange("Range", 32.0, 0.0, 100.0);
            COBBLE_TURRET_ARMOR = builder.defineInRange("Armor", 3.0, 0.0, 100.0);
            COBBLE_TURRET_RATE = builder.comment("In ticks").defineInRange("Fire rate", 20, 10, 60);
            COBBLE_TURRET_DAMAGE = builder.defineInRange("Damage", 3, 1, 100);
            builder.pop();
            return builder.build();
        }).getRight());
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(ID, "network"), () -> NP, NP::equals, NP::equals);
        int packetIndex = 0;
        channel.registerMessage(packetIndex++, TurretTargets.class, (turretTargets, packetBuffer) -> {
            packetBuffer.writeInt(turretTargets.turretID);
            packetBuffer.m_130079_(turretTargets.targets);
        }, packetBuffer -> {
            int id = packetBuffer.readInt();
            CompoundTag compoundNBT = packetBuffer.m_130260_();
            return new TurretTargets(compoundNBT, id);
        }, (turretTargets, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            ServerLevel serverWorld = context.getSender().m_183503_();
            Entity entity = serverWorld.m_6815_(turretTargets.turretID);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setTargets(turretTargets.targets);
                context.setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, DismantleTurret.class, (dismantleTurret, packetBuffer) -> packetBuffer.writeInt(dismantleTurret.id), packetBuffer -> new DismantleTurret(packetBuffer.readInt()), (dismantleTurret, contextSupplier) -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_183503_();
            Entity entity = serverWorld.m_6815_(dismantleTurret.id);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.getContainedItems().forEach(itemHandler -> Containers.m_19010_((Level)serverWorld, (BlockPos)turret.m_142538_(), (NonNullList)itemHandler.getItems()));
                turret.m_146870_();
                ItemStack egg = new ItemStack((ItemLike)turret.getSpawnItem());
                egg.m_41784_().m_128365_("Contained", (Tag)turret.serializeNBT());
                egg.m_41783_().m_128362_("UUID", turret.m_142081_());
                serverWorld.m_7967_((Entity)new ItemEntity((Level)serverWorld, turret.m_20185_(), turret.m_20186_(), turret.m_20189_(), egg));
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, ClaimTurret.class, (claimTurret, packetBuffer) -> {
            packetBuffer.writeInt(claimTurret.id);
            packetBuffer.m_130077_(claimTurret.person);
        }, packetBuffer -> new ClaimTurret(packetBuffer.readInt(), packetBuffer.m_130259_()), (claimTurret, contextSupplier) -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_183503_();
            Entity entity = serverWorld.m_6815_(claimTurret.id);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setOwner(claimTurret.person);
                if (turret instanceof Drone) {
                    ((NetworkEvent.Context)contextSupplier.get()).getSender().m_6352_((Component)new TranslatableComponent("k_turrets.drone_claimed"), turret.m_142081_());
                } else {
                    ((NetworkEvent.Context)contextSupplier.get()).getSender().m_6352_((Component)new TranslatableComponent("k_turrets.turret_claimed"), turret.m_142081_());
                }
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, ToggleMobility.class, (toggleMobility, packetBuffer) -> {
            packetBuffer.writeInt(toggleMobility.id);
            packetBuffer.writeBoolean(toggleMobility.mobile);
        }, packetBuffer -> {
            int id = packetBuffer.readInt();
            boolean mobile = packetBuffer.readBoolean();
            return new ToggleMobility(mobile, id);
        }, (toggleMobility, contextSupplier) -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_183503_();
            Entity entity = serverWorld.m_6815_(toggleMobility.id);
            if (entity instanceof Turret) {
                ((Turret)entity).setMoveable(toggleMobility.mobile);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex++, TogglePlayerProtection.class, (togglePlayerProtection, packetBuffer) -> {
            packetBuffer.writeBoolean(togglePlayerProtection.protect);
            packetBuffer.writeInt(togglePlayerProtection.id);
        }, packetBuffer -> new TogglePlayerProtection(packetBuffer.readBoolean(), packetBuffer.readInt()), (togglePlayerProtection, contextSupplier) -> {
            ServerLevel serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_183503_();
            Entity entity = serverWorld.m_6815_(togglePlayerProtection.id);
            if (entity instanceof Turret) {
                Turret turret = (Turret)entity;
                turret.setProtectionFromPlayers(togglePlayerProtection.protect);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        channel.registerMessage(packetIndex, ToggleDroneFollow.class, (toggleDroneFollow, friendlyByteBuf) -> {
            friendlyByteBuf.writeInt(toggleDroneFollow.id);
            friendlyByteBuf.writeBoolean(toggleDroneFollow.follow);
        }, friendlyByteBuf -> {
            int id = friendlyByteBuf.readInt();
            return new ToggleDroneFollow(friendlyByteBuf.readBoolean(), id);
        }, (toggleDroneFollow, contextSupplier) -> {
            ServerLevel serverLevel = ((NetworkEvent.Context)contextSupplier.get()).getSender().m_183503_();
            Entity entity = serverLevel.m_6815_(toggleDroneFollow.id);
            if (entity instanceof Drone) {
                Drone drone = (Drone)entity;
                drone.followOwner(toggleDroneFollow.follow);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
            ENABLE_DRONE_SOUND = builder.define("Enable drone flying sound", false);
            return builder.build();
        }).getRight());
    }
}

