/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.TurretOptionsScreen;
import dev.buildtool.satako.ItemHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class Turret
extends Mob
implements RangedAttackMob,
MenuProvider {
    private static final EntityDataAccessor<CompoundTag> TARGETS = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> MOVEABLE = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PROTECTION_FROM_PLAYERS = SynchedEntityData.m_135353_(Turret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected Predicate<LivingEntity> alienPlayers = livingEntity -> {
        if (this.getOwner().isPresent()) {
            return livingEntity instanceof Player && !livingEntity.m_142081_().equals(this.getOwner().get()) && !livingEntity.m_7307_((Entity)this.f_19853_.m_46003_(this.getOwner().get()));
        }
        return false;
    };

    public Turret(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createDefaultAttributes() {
        return Turret.m_21183_().m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        CompoundTag compoundNBT = new CompoundTag();
        List targets = ForgeRegistries.ENTITIES.getValues().stream().filter(entityType1 -> !entityType1.m_20674_().m_21609_()).collect(Collectors.toList());
        for (int i = 0; i < targets.size(); ++i) {
            compoundNBT.m_128359_("Target#" + i, ((EntityType)targets.get(i)).getRegistryName().toString());
        }
        compoundNBT.m_128405_("Count", targets.size());
        this.f_19804_.m_135372_(TARGETS, (Object)compoundNBT);
        this.f_19804_.m_135372_(OWNER, Optional.empty());
        this.f_19804_.m_135372_(MOVEABLE, (Object)false);
        this.f_19804_.m_135372_(PROTECTION_FROM_PLAYERS, (Object)false);
    }

    public void setTargets(CompoundTag compoundNBT) {
        this.f_19804_.m_135381_(TARGETS, (Object)compoundNBT);
    }

    public CompoundTag getTargets() {
        return (CompoundTag)this.f_19804_.m_135370_(TARGETS);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.f_19804_.m_135370_(OWNER);
    }

    public void setOwner(UUID owner) {
        this.f_19804_.m_135381_(OWNER, Optional.of(owner));
    }

    public void setMoveable(boolean moveable) {
        this.f_19804_.m_135381_(MOVEABLE, (Object)moveable);
    }

    public boolean isMoveable() {
        return (Boolean)this.f_19804_.m_135370_(MOVEABLE);
    }

    public void setProtectionFromPlayers(boolean protect) {
        this.f_19804_.m_135381_(PROTECTION_FROM_PLAYERS, (Object)protect);
    }

    public boolean isProtectingFromPlayers() {
        return (Boolean)this.f_19804_.m_135370_(PROTECTION_FROM_PLAYERS);
    }

    protected abstract void m_8099_();

    public boolean m_5789_() {
        return false;
    }

    public boolean m_6097_() {
        return true;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot p_184582_1_) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_184201_1_, ItemStack p_184201_2_) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected double getRange() {
        return this.m_21133_(Attributes.f_22277_);
    }

    protected double getDamage() {
        return this.m_21133_(Attributes.f_22281_);
    }

    protected InteractionResult m_6071_(Player playerEntity, InteractionHand interactionHand) {
        ItemStack itemInHand = playerEntity.m_21120_(interactionHand);
        if (this.m_21223_() < this.m_21233_() && itemInHand.m_204131_().anyMatch(itemTagKey -> itemTagKey.f_203868_().equals((Object)KTurrets.STEEL_INGOT))) {
            this.m_5634_(this.m_21233_() / 6.0f);
            itemInHand.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.canUse(playerEntity)) {
            if (this.f_19853_.f_46443_) {
                this.openTargetScreen();
            }
            return InteractionResult.SUCCESS;
        }
        if (this.f_19853_.f_46443_) {
            playerEntity.m_6352_((Component)new TextComponent("k-turrets.turret.not.yours"), Util.f_137441_);
        }
        return InteractionResult.PASS;
    }

    protected boolean canUse(Player playerEntity) {
        return !this.getOwner().isPresent() || this.getOwner().get().equals(playerEntity.m_142081_());
    }

    @OnlyIn(value=Dist.CLIENT)
    void openTargetScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new TurretOptionsScreen(this));
    }

    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128365_("Targets", (Tag)this.getTargets());
        this.getOwner().ifPresent(uuid1 -> compoundNBT.m_128362_("Owner", uuid1));
        compoundNBT.m_128379_("Mobile", this.isMoveable());
        compoundNBT.m_128379_("Player protection", this.isProtectingFromPlayers());
    }

    public void m_7378_(CompoundTag compoundNBT) {
        UUID uuid;
        super.m_7378_(compoundNBT);
        this.setTargets(compoundNBT.m_128469_("Targets"));
        if (compoundNBT.m_128441_("Owner") && !(uuid = compoundNBT.m_128342_("Owner")).equals(Util.f_137441_)) {
            this.setOwner(uuid);
        }
        this.setMoveable(compoundNBT.m_128471_("Mobile"));
        this.setProtectionFromPlayers(compoundNBT.m_128471_("Player protection"));
    }

    public List<EntityType<?>> decodeTargets(CompoundTag compoundNBT) {
        int count = compoundNBT.m_128451_("Count");
        ArrayList list = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            String next = compoundNBT.m_128461_("Target#" + i);
            list.add((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(next)));
        }
        return list;
    }

    public CompoundTag encodeTargets(List<EntityType<?>> list) {
        CompoundTag compoundNBT = new CompoundTag();
        for (int i = 0; i < list.size(); ++i) {
            EntityType<?> entityType = list.get(i);
            compoundNBT.m_128359_("Target#" + i, entityType.getRegistryName().toString());
        }
        compoundNBT.m_128405_("Count", list.size());
        return compoundNBT;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.getContainedItems().forEach(itemHandler -> Containers.m_19010_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (NonNullList)itemHandler.getItems()));
    }

    protected abstract List<ItemHandler> getContainedItems();

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12346_;
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        MobEffect effect = effectInstance.m_19544_();
        if (effect == MobEffects.f_19614_ || effect == MobEffects.f_19601_ || effect == MobEffects.f_19616_ || effect == MobEffects.f_19605_ || effect == MobEffects.f_19615_ || effect == MobEffects.f_19612_) {
            return false;
        }
        return super.m_7301_(effectInstance);
    }

    public boolean m_5829_() {
        return !this.isMoveable();
    }

    public boolean m_6094_() {
        return this.isMoveable();
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        if (this.isMoveable()) {
            super.m_147240_(p_147241_, p_147242_, p_147243_);
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11892_;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public Item getSpawnItem() {
        return ForgeSpawnEggItem.fromEntityType((EntityType)this.m_6095_());
    }

    public boolean m_7307_(Entity target) {
        Turret turret;
        return super.m_7307_(target) || this.getOwner().isPresent() && target.m_142081_().equals(this.getOwner().get()) || target instanceof Turret && (turret = (Turret)target).getOwner().isPresent() && turret.getOwner().equals(this.getOwner());
    }

    public boolean m_6673_(DamageSource p_20122_) {
        Entity source = p_20122_.m_7639_();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (this.getOwner().isPresent() && player.m_142081_().equals(this.getOwner().get())) {
                return true;
            }
        }
        return super.m_6673_(p_20122_);
    }

    public abstract boolean isArmed();
}

