/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.kturrets;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.buildtool.kturrets.Drone;
import dev.buildtool.kturrets.KTurrets;
import dev.buildtool.kturrets.Turret;
import dev.buildtool.kturrets.packets.ClaimTurret;
import dev.buildtool.kturrets.packets.DismantleTurret;
import dev.buildtool.kturrets.packets.ToggleDroneFollow;
import dev.buildtool.kturrets.packets.ToggleMobility;
import dev.buildtool.kturrets.packets.TogglePlayerProtection;
import dev.buildtool.kturrets.packets.TurretTargets;
import dev.buildtool.satako.UniqueList;
import dev.buildtool.satako.gui.BetterButton;
import dev.buildtool.satako.gui.Label;
import dev.buildtool.satako.gui.Screen2;
import dev.buildtool.satako.gui.SwitchButton;
import dev.buildtool.satako.gui.TextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class TurretOptionsScreen
extends Screen2 {
    protected Turret turret;
    protected HashMap<EntityType<?>, Boolean> tempStatusMap;
    protected List<EntityType<?>> targets;
    private static final TranslatableComponent CHOOSE_HINT = new TranslatableComponent("k_turrets.choose.tooltip");
    private static final TranslatableComponent SCROLL_HINT = new TranslatableComponent("k_turrets.hold.alt.to.scroll");
    private static final TranslatableComponent INVENTORY_HINT = new TranslatableComponent("k_turrets.inventory.hint");
    private List<SwitchButton> targetButtons;
    private TextField addEntityField;

    public TurretOptionsScreen(Turret turret) {
        super(new TranslatableComponent("k_turrets.targets"));
        this.turret = turret;
        this.tempStatusMap = new HashMap(40);
        this.targets = new UniqueList(turret.decodeTargets(turret.getTargets()));
        this.targets.forEach(entityType -> this.tempStatusMap.put((EntityType<?>)entityType, true));
    }

    public void m_7856_() {
        super.m_7856_();
        this.addEntityField = (TextField)this.m_142416_((GuiEventListener)new TextField(this.centerX, 3, 100));
        this.m_142416_((GuiEventListener)new BetterButton(this.centerX, 20, (Component)new TranslatableComponent("k_turrets.add.entity.type"), p_onPress_1_ -> {
            String entityType = this.addEntityField.m_94155_();
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityType));
            if (entityType.length() > 2 && type != null) {
                if (type == EntityType.f_20510_ && !entityType.equals("minecraft:pig") && !entityType.equals("pig")) {
                    this.f_96541_.f_91074_.m_6352_((Component)new TranslatableComponent("k_turrets.incorrect.entry"), Util.f_137441_);
                } else {
                    this.targets.add(type);
                    this.tempStatusMap.put(type, true);
                    this.f_96541_.f_91074_.m_6352_((Component)new TranslatableComponent("k_turrets.added").m_130946_(" ").m_7220_(type.m_20676_()), Util.f_137441_);
                    if (entityType.contains(":")) {
                        this.addEntityField.m_94144_(entityType.substring(0, entityType.indexOf(58)));
                    }
                }
            }
        }));
        this.m_142416_((GuiEventListener)new BetterButton(this.centerX, 40, (Component)new TranslatableComponent("k_turrets.dismantle"), p_onPress_1_ -> {
            KTurrets.channel.sendToServer((Object)new DismantleTurret(this.turret.m_142049_()));
            this.f_96541_.f_91074_.m_6915_();
        }));
        BetterButton clearTargets = new BetterButton(this.centerX, 60, (Component)new TranslatableComponent("k_turrets.clear.list"), p_onPress_1_ -> {
            this.targets.clear();
            this.tempStatusMap.clear();
            this.targetButtons.forEach(this.f_169369_::remove);
        });
        this.m_142416_((GuiEventListener)clearTargets);
        this.m_142416_((GuiEventListener)new BetterButton(clearTargets.f_93620_ + clearTargets.m_5711_(), 60, (Component)new TranslatableComponent("k_turrets.reset.list"), p_93751_ -> {
            this.targets = ForgeRegistries.ENTITIES.getValues().stream().filter(entityType1 -> !entityType1.m_20674_().m_21609_()).collect(Collectors.toList());
            this.targets.forEach(entityType -> this.tempStatusMap.put((EntityType<?>)entityType, true));
            this.f_96541_.f_91080_.m_7379_();
            this.f_96541_.f_91074_.m_6915_();
        }));
        this.m_142416_((GuiEventListener)new SwitchButton(this.centerX, 80, (Component)new TranslatableComponent("k_turrets.mobile"), (Component)new TranslatableComponent("k_turrets.immobile"), this.turret.isMoveable(), p_onPress_1_ -> {
            KTurrets.channel.sendToServer((Object)new ToggleMobility(!this.turret.isMoveable(), this.turret.m_142049_()));
            this.turret.setMoveable(!this.turret.isMoveable());
            if (p_onPress_1_ instanceof SwitchButton) {
                ((SwitchButton)p_onPress_1_).state = !((SwitchButton)p_onPress_1_).state;
            }
        }));
        this.m_142416_((GuiEventListener)new SwitchButton(this.centerX, 100, (Component)new TranslatableComponent("k_turrets.protect.from.players"), (Component)new TranslatableComponent("k_turrets.not.protect.from.players"), this.turret.isProtectingFromPlayers(), p_onPress_1_ -> {
            KTurrets.channel.sendToServer((Object)new TogglePlayerProtection(!this.turret.isProtectingFromPlayers(), this.turret.m_142049_()));
            this.turret.setProtectionFromPlayers(!this.turret.isProtectingFromPlayers());
            if (p_onPress_1_ instanceof SwitchButton) {
                ((SwitchButton)p_onPress_1_).state = !((SwitchButton)p_onPress_1_).state;
            }
        }));
        if (!this.turret.getOwner().isPresent()) {
            this.m_142416_((GuiEventListener)new BetterButton(this.centerX, 120, (Component)new TranslatableComponent(this.turret instanceof Drone ? "k_turrets.claim.drone" : "k_turrets.claim.turret"), p_onPress_1_ -> {
                KTurrets.channel.sendToServer((Object)new ClaimTurret(this.turret.m_142049_(), this.f_96541_.f_91074_.m_142081_()));
                this.turret.setOwner(this.f_96541_.f_91074_.m_142081_());
                this.f_96541_.f_91074_.m_6915_();
            }));
        } else {
            Turret turret = this.turret;
            if (turret instanceof Drone) {
                Drone drone = (Drone)turret;
                this.m_142416_((GuiEventListener)new SwitchButton(this.centerX, 120, (Component)new TranslatableComponent("k_turrets.following.owner"), (Component)new TranslatableComponent("k_turrets.staying"), drone.isFollowingOwner(), p_93751_ -> {
                    KTurrets.channel.sendToServer((Object)new ToggleDroneFollow(!drone.isFollowingOwner(), drone.m_142049_()));
                    drone.followOwner(!drone.isFollowingOwner());
                    if (p_93751_ instanceof SwitchButton) {
                        SwitchButton switchButton = (SwitchButton)p_93751_;
                        switchButton.state = !switchButton.state;
                    }
                }));
            }
        }
        this.m_142416_((GuiEventListener)new Label(3, 3, (Component)new TranslatableComponent("k_turrets.targets")));
        this.targetButtons = new ArrayList<SwitchButton>(this.targets.size());
        for (int i = 0; i < this.targets.size(); ++i) {
            EntityType<?> entityType = this.targets.get(i);
            SwitchButton switchButton = new SwitchButton(3, 20 * i + 40, (Component)new TextComponent(entityType.getRegistryName().toString()), (Component)new TextComponent(ChatFormatting.STRIKETHROUGH + entityType.getRegistryName().toString()), true, p_onPress_1_ -> {
                if (p_onPress_1_ instanceof SwitchButton) {
                    ((SwitchButton)p_onPress_1_).state = !((SwitchButton)p_onPress_1_).state;
                    this.tempStatusMap.put(entityType, ((SwitchButton)p_onPress_1_).state);
                }
            });
            switchButton.verticalScroll = true;
            this.m_142416_((GuiEventListener)switchButton);
            this.targetButtons.add(switchButton);
        }
    }

    public void m_7379_() {
        super.m_7379_();
        AtomicInteger removed = new AtomicInteger();
        this.tempStatusMap.forEach((entityType, aBoolean) -> {
            if (aBoolean.booleanValue()) {
                this.targets.add((EntityType<?>)entityType);
            } else {
                this.targets.remove(entityType);
                removed.getAndIncrement();
            }
        });
        CompoundTag compoundNBT = this.turret.encodeTargets(this.targets);
        this.turret.setTargets(compoundNBT);
        TurretTargets turretTargets = new TurretTargets(compoundNBT, this.turret.m_142049_());
        KTurrets.channel.sendToServer((Object)turretTargets);
        if (removed.get() > 0) {
            this.f_96541_.f_91074_.m_6352_((Component)new TranslatableComponent("k_turrets.removed", new Object[]{removed.get()}), this.turret.m_142081_());
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float tick) {
        List entityTypes;
        super.m_6305_(matrixStack, mouseX, mouseY, tick);
        this.renderComponentTooltip(matrixStack, Collections.singletonList(new TranslatableComponent("k_turrets.integrity").m_130946_(": " + (int)this.turret.m_21223_() + "/" + this.turret.m_21233_())), this.centerX, this.centerY + 40, this.f_96547_);
        this.renderComponentTooltip(matrixStack, Arrays.asList(CHOOSE_HINT, SCROLL_HINT), this.centerX, this.centerY + 60, this.f_96547_);
        String targetEntry = this.addEntityField.m_94155_();
        if (targetEntry.length() > 0 && !(entityTypes = targetEntry.contains(":") ? ForgeRegistries.ENTITIES.getKeys().stream().filter(resourceLocation -> resourceLocation.toString().contains(targetEntry)).collect(Collectors.toList()) : ForgeRegistries.ENTITIES.getKeys().stream().filter(resourceLocation -> resourceLocation.m_135827_().contains(targetEntry)).collect(Collectors.toList())).isEmpty()) {
            this.m_96597_(matrixStack, entityTypes.subList(0, Math.min(entityTypes.size(), 12)).stream().map(resourceLocation -> new TextComponent(ChatFormatting.YELLOW + resourceLocation.toString())).collect(Collectors.toList()), this.addEntityField.f_93620_, this.addEntityField.f_93621_ + this.addEntityField.m_93694_() + 20);
        }
    }
}

