/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.buildtool.satako.Functions;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.Options;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Methods {
    public static final Random RANDOMGENERATOR = new Random();

    public static void setBlocks(BlockPos from, BlockPos to, BlockState state, Level world) {
        Stream poss = BlockPos.m_121990_((BlockPos)from, (BlockPos)to);
        poss.forEach(blockPos -> world.m_46597_(blockPos, state));
    }

    public static void removeTileEntitySilently(BlockPos pos, Level world) {
        BlockEntity tileentity = world.m_7702_(pos);
        try {
            Field processingLoadedTiles = Functions.isObfuscatedEnvironment() ? Functions.getSecureField(Level.class, Options.processingLoadedTiles) : Functions.getSecureField(world.getClass(), "updatingBlockEntities");
            Field addedTileEntityList = Functions.isObfuscatedEnvironment() ? Functions.getSecureField(Level.class, Options.addedTileEntityList) : Functions.getSecureField(world.getClass(), "pendingBlockEntities");
            List atl = (List)addedTileEntityList.get(world);
            if (tileentity != null && processingLoadedTiles.getBoolean(world)) {
                tileentity.m_7651_();
                atl.remove(tileentity);
                world.m_46747_(pos);
            } else {
                if (tileentity != null) {
                    atl.remove(tileentity);
                    world.m_46747_(pos);
                }
                ChunkAccess chunk = world.m_46865_(pos);
                chunk.m_8114_(pos);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void drawCircle(Tesselator tessellator) {
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
        int num_segments = 16;
        float radius = 0.7f;
        for (int ii = 0; ii < num_segments; ++ii) {
            float theta = 6.283185f * (float)ii / (float)num_segments;
            float xx = radius * Mth.m_14089_((float)theta);
            float yy = radius * Mth.m_14031_((float)theta);
            bufferbuilder.m_5483_((double)xx, (double)yy, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
        }
        tessellator.m_85914_();
    }

    private static void drawFilledCircle(Tesselator tessellator, float radius, Color color) {
        int circle_points = 50;
        float angle = 6.2832f / (float)circle_points;
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        double angle1 = 0.0;
        double xx = (double)radius * Math.cos(0.0);
        double yy = (double)radius * Math.sin(0.0);
        bufferBuilder.m_5483_(xx, yy, 0.0).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), 255).m_5752_();
        for (int i = 0; i < circle_points; ++i) {
            bufferBuilder.m_5483_((double)radius * Math.cos(angle1), (double)radius * Math.sin(angle1), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            angle1 += (double)angle;
        }
        tessellator.m_85914_();
    }

    public static boolean setBlockStateSilently(Level world, BlockPos targetPos, BlockState newState) {
        return false;
    }

    public static void drawStringWithBackground(PoseStack matrixStack, Object obj, int x, int y, IntegerColor background) {
        String string = obj.toString();
        Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, string, (float)(x + 2), (float)(y + 4), background.getIntColor());
    }

    public static void sendBlockUpdate(ServerLevel worldServer, BlockPos blockPos) {
        BlockState blockState = worldServer.m_8055_(blockPos);
        worldServer.m_7260_(blockPos, blockState, blockState, 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openClientGui(Level world, Screen screen) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91152_(screen);
        }
    }

    public static void playSound(Level world, BlockPos blockPos, SoundEvent sound, float volume, float pitch) {
        world.m_7785_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), sound, null, volume, pitch, false);
    }

    public static void sendMessageToPlayer(Player player, String message) {
        player.m_6352_((Component)new TextComponent(message), player.m_142081_());
    }

    public static void drawCenteredString(PoseStack matrixStack, TextComponent o, int X, int Y, IntegerColor color) {
        Methods.drawString(matrixStack, o, X - Functions.calculateStringWidth((Component)o) / 2, Y, color);
    }

    public static void drawCenteredStringWithShadow(PoseStack matrixStack, TextComponent o, int X, int Y, IntegerColor color) {
        Methods.drawStringWithShadow(matrixStack, o, X - Functions.calculateStringWidth((Component)o) / 2, Y, color);
    }

    public static void drawString(PoseStack matrixStack, Object o, int X, int Y, IntegerColor color) {
        Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, o.toString(), (float)X, (float)Y, color.getIntColor());
    }

    public static void drawStringWithShadow(PoseStack matrixStack, Object o, int X, int Y, IntegerColor color) {
        Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, o.toString(), (float)X, (float)Y, color.getIntColor());
    }

    public static void show(Object[] objects) {
        System.out.println(Arrays.toString(objects));
    }

    public static void addPotionEffectNoParticles(LivingEntity entityLivingBase, MobEffect potion, int duration, int strength) {
        entityLivingBase.m_7292_(new MobEffectInstance(potion, duration, strength, false, false));
    }
}

