/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako;

import dev.buildtool.satako.debugging.Analyzer;
import dev.buildtool.satako.debugging.EventListener;
import dev.buildtool.satako.packets.SendItemNBT;
import dev.buildtool.satako.packets.SendSound;
import dev.buildtool.satako.test.TestBlock;
import dev.buildtool.satako.test.TestContainer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="satako")
public class Satako {
    public static final String ID = "satako";
    public static SimpleChannel CHANNEL;
    public static ForgeConfigSpec.BooleanValue DO_DEBUG;
    private static final DeferredRegister<Block> BLOCKS;
    private static final RegistryObject<Block> TEST_BLOCK;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINER_TYPES;
    public static final RegistryObject<MenuType<TestContainer>> TEST_CONTAINER;

    public Satako() {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(ID, "first"), () -> "1.0", s -> true, s -> true);
        CHANNEL.messageBuilder(SendItemNBT.class, 0).encoder((sendItemNBT, packetBuffer) -> {
            packetBuffer.m_130079_(sendItemNBT.compoundNBT);
            packetBuffer.m_130068_((Enum)sendItemNBT.toHand);
        }).decoder(packetBuffer -> new SendItemNBT(packetBuffer.m_130260_(), (InteractionHand)packetBuffer.m_130066_(InteractionHand.class))).consumer((sendItemNBT, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                context.enqueueWork(() -> context.getSender().m_21120_(sendItemNBT.toHand).m_41751_(sendItemNBT.compoundNBT));
            } else {
                context.enqueueWork(() -> {
                    Minecraft minecraft = Minecraft.m_91087_();
                    ItemStack heldItem = minecraft.f_91074_.m_21120_(sendItemNBT.toHand);
                    heldItem.m_41751_(sendItemNBT.compoundNBT);
                });
            }
            context.setPacketHandled(true);
        }).add();
        CHANNEL.messageBuilder(SendSound.class, 1, NetworkDirection.PLAY_TO_CLIENT).encoder((sendSound, buffer) -> {
            buffer.writeFloat(sendSound.pitch);
            buffer.writeFloat(sendSound.volume);
            buffer.m_130070_(sendSound.soundEvent.getRegistryName().toString());
        }).decoder(buffer -> new SendSound(buffer.readFloat(), buffer.readFloat(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(buffer.m_130277_())))).consumer((sendSound, contextSupplier) -> {
            ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(() -> Minecraft.m_91087_().f_91074_.m_5496_(sendSound.soundEvent, sendSound.volume, sendSound.pitch));
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        }).add();
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)new ForgeConfigSpec.Builder().configure(builder -> {
            DO_DEBUG = builder.define("Enable extra debugging info", false);
            return builder.build();
        }).getRight());
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CONTAINER_TYPES.register(eventBus);
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        if (((Boolean)DO_DEBUG.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register(EventListener.class);
            eventBus.register(Analyzer.class);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    PrintWriter printWriter = new PrintWriter(new File("logs", "general.log"));
                    ModList.get().forEachModContainer((s, modContainer) -> {
                        if (!s.equals("minecraft") && !s.equals("forge")) {
                            printWriter.println("Next mod: " + s);
                            IModInfo iModInfo = modContainer.getModInfo();
                            iModInfo.getDependencies().forEach(modVersion -> printWriter.println("depends " + (modVersion.isMandatory() ? "obligatory" : "optionally") + " on " + modVersion.getModId()));
                        }
                    });
                    printWriter.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }));
        }
    }

    static {
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)ID);
        TEST_BLOCK = BLOCKS.register("test_block", () -> new TestBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76281_, (MaterialColor)MaterialColor.f_76413_)));
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)ID);
        ITEMS.register("test_block", () -> new BlockItem((Block)TEST_BLOCK.get(), new Item.Properties().m_41487_(1)));
        CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)ID);
        TEST_CONTAINER = CONTAINER_TYPES.register("test_block", () -> IForgeMenuType.create((windowId, inv, data) -> new TestContainer(windowId, inv)));
    }
}

