/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.debugging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventListener {
    private static ResourceLocation lastConstructedEntity;
    private static ResourceLocation lastEntityAddedToChunk;
    private static ResourceLocation lastEntityAddedToWorld;
    private static ResourceLocation lastBlockPlacedByEntity;
    private static ResourceLocation placer;
    private static ResourceLocation lastBlockPlacedByFluid;
    private static ResourceLocation lastBlockToBeBroken;
    private static ResourceLocation lastItemUsedByEntity;
    private static ResourceLocation lastUser;

    @SubscribeEvent
    public static void trackEntityConstruction(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        lastConstructedEntity = entity.m_6095_().getRegistryName();
    }

    @SubscribeEvent
    public static void trackEntityEnteringChunk(EntityEvent.EnteringSection event) {
        Entity entity = event.getEntity();
        lastEntityAddedToChunk = entity.m_6095_().getRegistryName();
    }

    @SubscribeEvent
    public static void trackEntityJoin(EntityJoinWorldEvent event) {
        lastEntityAddedToWorld = event.getEntity().m_6095_().getRegistryName();
    }

    @SubscribeEvent
    public static void trackPlacementByEntity(BlockEvent.EntityPlaceEvent event) {
        lastBlockPlacedByEntity = event.getPlacedBlock().m_60734_().getRegistryName();
        if (event.getEntity() != null) {
            placer = event.getEntity().m_6095_().getRegistryName();
        }
    }

    @SubscribeEvent
    public static void trackPlacementByFluid(BlockEvent.FluidPlaceBlockEvent event) {
        lastBlockPlacedByFluid = event.getOriginalState().m_60734_().getRegistryName();
    }

    @SubscribeEvent
    public static void trackBreak(BlockEvent.BreakEvent breakEvent) {
        lastBlockToBeBroken = breakEvent.getState().m_60734_().getRegistryName();
    }

    @SubscribeEvent
    public static void trackUseByEntity(LivingEntityUseItemEvent event) {
        lastItemUsedByEntity = event.getItem().m_41720_().getRegistryName();
        lastUser = event.getEntityLiving().m_6095_().getRegistryName();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(new File("logs", "event-log.txt")));
                writer.println("Last entity being constructed: " + lastConstructedEntity);
                writer.println("Last entity added to world: " + lastEntityAddedToWorld);
                writer.println("Last entity added to chunk: " + lastEntityAddedToChunk);
                writer.println("Last block to be broken: " + lastBlockToBeBroken);
                writer.println("Last block to be placed by " + placer + ": " + lastBlockPlacedByEntity);
                writer.println("Last block to be placed by fluid: " + lastBlockPlacedByFluid);
                writer.println("Last item used by " + lastUser + ": " + lastItemUsedByEntity);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }
}

