/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.buildtool.satako.Constants;
import dev.buildtool.satako.IntegerColor;
import dev.buildtool.satako.ItemHandlerSlot;
import dev.buildtool.satako.gui.Page;
import dev.buildtool.satako.gui.ScrollList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class ContainerScreen2<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected ArrayList<ScrollList> lists = new ArrayList(0);
    protected int centerX;
    protected int centerY;
    protected ArrayList<Page> pages = new ArrayList(0);
    protected boolean drawBorders;

    public ContainerScreen2(T container, Inventory playerInventory, Component name, boolean drawBorders_) {
        super(container, playerInventory, name);
        if (Minecraft.m_91087_().f_91080_ != null) {
            Minecraft.m_91087_().f_91080_ = null;
        }
        this.drawBorders = drawBorders_;
    }

    public void m_7856_() {
        this.lists.clear();
        int maxX = 0;
        int minX = this.getXSize();
        int maxY = 0;
        for (Slot slot : this.getSlots()) {
            int y;
            int x = slot.f_40220_;
            if (x > maxX) {
                maxX = x;
            }
            if (minX > x) {
                minX = x;
            }
            if ((y = slot.f_40221_) <= maxY) continue;
            maxY = y;
        }
        this.f_97726_ = maxX + 18;
        this.f_97727_ = maxY + 18;
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
    }

    protected List<Slot> getSlots() {
        return this.f_97732_.f_38839_;
    }

    public void m_6305_(PoseStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        this.m_7025_(matrixStack, p_render_1_, p_render_2_);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        List<Slot> slots = this.getSlots();
        GlStateManager.m_84318_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Slot s : slots) {
            if (!s.m_6659_()) continue;
            int sx = s.f_40220_;
            int sy = s.f_40221_;
            TextureManager textureManager = this.f_96541_.m_91097_();
            if (s instanceof ItemHandlerSlot) {
                ItemHandlerSlot itemHandlerSlot = (ItemHandlerSlot)s;
                if (itemHandlerSlot.getTexture() == null) {
                    ContainerScreen2.m_93172_((PoseStack)matrixStack, (int)(sx + this.f_97735_), (int)(sy + this.f_97736_), (int)(sx + this.f_97735_ + 16), (int)(sy + this.f_97736_ + 16), (int)itemHandlerSlot.getColor().getIntColor());
                    continue;
                }
                textureManager.m_174784_(itemHandlerSlot.getTexture());
                this.m_93228_(matrixStack, sx + this.f_97735_, sy + this.f_97736_, 0, 0, 16, 16);
                continue;
            }
            Pair atlasAndSprite = s.m_7543_();
            if (atlasAndSprite != null) {
                ResourceLocation background = (ResourceLocation)atlasAndSprite.getSecond();
                if (background.m_135827_().equals("minecraft")) {
                    textureManager.m_174784_(Constants.GREY_SLOT_TEXTURE);
                } else {
                    textureManager.m_174784_(background);
                }
            } else {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)Constants.GREY_SLOT_TEXTURE);
            }
            this.m_93228_(matrixStack, sx + this.f_97735_, sy + this.f_97736_, 0, 0, 16, 16);
        }
        IntegerColor color = Constants.BLUE;
        this.lists.forEach(ScrollList::draw);
        if (this.drawBorders) {
            int intColor = color.getIntColor();
            this.m_93154_(matrixStack, this.f_97735_ - 1, this.getXSize() + this.f_97735_ - 2, this.f_97736_ - 1, intColor);
            this.m_93154_(matrixStack, this.f_97735_, this.getXSize() + this.f_97735_ - 2, this.getYSize() + this.f_97736_ - 2, intColor);
            this.m_93222_(matrixStack, this.f_97735_ - 1, this.f_97736_ - 1, this.getYSize() + this.f_97736_ - 1, intColor);
            this.m_93222_(matrixStack, this.getXSize() + this.f_97735_ - 2, this.f_97736_ - 1, this.getYSize() + this.f_97736_ - 2, intColor);
        }
    }

    public void addScrollList(ScrollList list) {
        this.lists.add(list);
    }

    protected void m_7027_(PoseStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }
}

