/*
 * Decompiled with CFR 0.152.
 */
package dev.buildtool.satako.gui;

import dev.buildtool.satako.UniqueList;
import dev.buildtool.satako.gui.Hideable;
import dev.buildtool.satako.gui.Positionable;
import dev.buildtool.satako.gui.Scrollable;

public class ScrollList
implements Scrollable,
Hideable {
    public UniqueList<Object> items = new UniqueList(2);
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean visible = true;
    protected int scrollAmount;

    public ScrollList(int x, int y, int width_, int height_, Object ... entries) {
        this.x = x;
        this.y = y;
        this.width = width_;
        this.height = height_;
        if (entries != null) {
            for (Object object : entries) {
                this.addItem(object);
            }
        }
    }

    public void addItem(Object o) {
        Positionable positionable;
        if (o instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)o;
            scrollable.setScrollable(true, true);
        }
        if (o instanceof Positionable && o instanceof Hideable && ((positionable = (Positionable)o).getY() < this.y || positionable.getY() + positionable.getHeight() > this.y + this.height)) {
            ((Hideable)o).setHidden();
        }
        this.items.add(o);
    }

    public void draw() {
        if (this.visible) {
            // empty if block
        }
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (this.visible) {
            for (Object e : this.items) {
                if (e instanceof Scrollable) {
                    ((Scrollable)e).scroll(amount, vertical);
                }
                if (!(e instanceof Positionable) || !(e instanceof Hideable)) continue;
                Positionable p = (Positionable)e;
                Hideable h = (Hideable)e;
                if (p.getY() + p.getHeight() > this.y + this.height || p.getY() < this.y) {
                    h.setHidden();
                    continue;
                }
                h.setVisible();
            }
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
    }

    @Override
    public void setEnabled() {
    }

    @Override
    public void setDisabled() {
    }

    @Override
    public void setScrollAmount(int pixels) {
        this.scrollAmount = pixels;
    }

    @Override
    public void setHidden() {
        this.visible = false;
        for (Object e : this.items) {
            if (!(e instanceof Hideable)) continue;
            ((Hideable)e).setHidden();
        }
    }

    @Override
    public void setVisible() {
        this.visible = true;
        for (Object e : this.items) {
            if (!(e instanceof Hideable)) continue;
            if (this.isElementInside(e)) {
                ((Hideable)e).setVisible();
                continue;
            }
            ((Hideable)e).setHidden();
        }
    }

    private boolean isElementInside(Object o) {
        if (o instanceof Positionable) {
            Positionable positionable = (Positionable)o;
            return positionable.getY() + positionable.getHeight() <= this.y + this.height && positionable.getY() >= this.y;
        }
        return false;
    }
}

